/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.apigen.generator;

import com.google.common.base.CaseFormat;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.dmr.ModelType;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.logmanager.Level;
import org.wildfly.apigen.generator.GeneratorScope;
import org.wildfly.apigen.generator.Keywords;
import org.wildfly.apigen.generator.ResourceMetaData;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Subresource;
import org.wildfly.apigen.invocation.Types;
import org.wildfly.apigen.model.AddressTemplate;
import org.wildfly.apigen.model.ResourceDescription;

public class SourceFactory {
    private static final Logger log = Logger.getLogger(SourceFactory.class.getName());

    public static JavaClassSource createResourceAsClass(GeneratorScope scope, ResourceMetaData metaData) {
        String className = Types.javaClassName(metaData);
        JavaClassSource javaClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)("public class " + className + " {}"));
        ((FieldSource)((FieldSource)javaClass.addField().setName("key")).setPrivate()).setType(String.class);
        boolean isSingleton = metaData.getDescription().isSingleton();
        if (isSingleton) {
            ((MethodSource)javaClass.addMethod().setConstructor(true).setPublic()).setBody("this.key = \"" + metaData.getDescription().getSingletonName() + "\";");
        } else {
            ((MethodSource)javaClass.addMethod().setConstructor(true).setPublic()).setBody("this.key = key;").addParameter(String.class, "key");
        }
        MethodSource keyAccessor = ((MethodSource)((MethodSource)javaClass.addMethod().setName("getKey")).setPublic()).setReturnType(String.class).setBody("return this.key;");
        javaClass.setPackage(SourceFactory.derivePackageName(metaData));
        JavaDocSource javaDoc = javaClass.getJavaDoc();
        ResourceDescription desc = metaData.getDescription();
        javaDoc.setText(desc.getText());
        javaClass.addImport(Implicit.class);
        javaClass.addImport(Address.class);
        javaClass.addImport(Binding.class);
        AnnotationSource addressMeta = javaClass.addAnnotation();
        addressMeta.setName("Address");
        addressMeta.setStringValue(metaData.getAddress().getTemplate());
        if (isSingleton) {
            AnnotationSource implicitMeta = javaClass.addAnnotation();
            implicitMeta.setName("Implicit");
        }
        desc.getAttributes().forEach(att -> {
            ModelType modelType = ModelType.valueOf((String)att.getValue().get("type").asString());
            Optional<String> resolvedType = Types.resolveJavaTypeName(modelType, att.getValue());
            if (resolvedType.isPresent()) {
                try {
                    String name = Types.javaAttributeName(att.getName());
                    String attributeDescription = att.getValue().get("description").asString();
                    ((FieldSource)javaClass.addField().setName(name)).setType(resolvedType.get()).setPrivate();
                    MethodSource accessor = javaClass.addMethod();
                    accessor.getJavaDoc().setText(attributeDescription);
                    ((MethodSource)((MethodSource)accessor.setPublic()).setName(name)).setReturnType(resolvedType.get()).setBody("return this." + name + ";");
                    MethodSource mutator = javaClass.addMethod();
                    mutator.getJavaDoc().setText(attributeDescription);
                    mutator.addParameter(resolvedType.get(), "value");
                    ((MethodSource)((MethodSource)mutator.setPublic()).setName(name)).setReturnType(className).setBody("this." + name + " = value;\nreturn this;");
                    AnnotationSource bindingMeta = accessor.addAnnotation();
                    bindingMeta.setName("Binding");
                    bindingMeta.setStringValue("detypedName", att.getName());
                }
                catch (Exception e) {
                    log.log((java.util.logging.Level)Level.ERROR, "Failed to process " + metaData.getAddress() + ", attribute " + att.getName(), e);
                }
            }
        });
        return javaClass;
    }

    private static String derivePackageName(ResourceMetaData metaData) {
        int level = metaData.getAddress().tokenLength();
        StringBuffer sb = new StringBuffer();
        if (level > 1) {
            for (int subLevel = level; subLevel >= 1; --subLevel) {
                AddressTemplate sub = metaData.getAddress().subTemplate(subLevel - 1, subLevel);
                String type = sub.getResourceType().replace("-", "_");
                String subPackage = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, type);
                sb.insert(0, "." + subPackage);
            }
        }
        sb.insert(0, metaData.get(ResourceMetaData.PKG));
        return sb.toString();
    }

    public static void createChildAccessors(GeneratorScope scope, ResourceMetaData resourceMetaData, JavaClassSource javaClass) {
        JavaClassSource subresourceClass = SourceFactory.createSubresourceClass(resourceMetaData, javaClass);
        ResourceDescription resourceMetaDataDescription = resourceMetaData.getDescription();
        Set<String> childrenNames = resourceMetaDataDescription.getChildrenTypes();
        for (String childName : childrenNames) {
            String propName;
            AddressTemplate childAddress = resourceMetaData.getAddress().append(childName + "=*");
            JavaClassSource childClass = scope.getGenerated(childAddress);
            javaClass.addImport((JavaType)childClass);
            String childClassName = childClass.getName();
            String propType = "java.util.List<" + childClassName + ">";
            String singularName = propName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, Keywords.escape(childClassName));
            if (!propName.endsWith("s")) {
                propName = propName + "s";
            }
            String resourceText = resourceMetaDataDescription.getChildDescription(childName).getText();
            ((FieldSource)((FieldSource)subresourceClass.addField().setName(propName)).setType(propType).setPrivate()).setLiteralInitializer("new java.util.ArrayList<>();").getJavaDoc().setText(resourceText);
            MethodSource accessor = subresourceClass.addMethod();
            accessor.getJavaDoc().setText("Get the list of " + childClassName + " resources").addTagValue("@return", "the list of resources");
            ((MethodSource)((MethodSource)accessor.setPublic()).setName(propName)).setReturnType(propType).setBody("return this." + propName + ";");
            MethodSource listMutator = javaClass.addMethod();
            listMutator.getJavaDoc().setText("Add all " + childClassName + " objects to this subresource").addTagValue("@return", "this").addTagValue("@param", "value List of " + childClassName + " objects.");
            listMutator.addParameter(propType, "value");
            ((MethodSource)((MethodSource)listMutator.setPublic()).setName(propName)).setReturnType(javaClass.getName()).setBody("this.subresources." + propName + ".addAll(value);\nreturn this;");
            MethodSource mutator = javaClass.addMethod();
            mutator.getJavaDoc().setText("Add the " + childClassName + " object to the list of subresources").addTagValue("@param", "value The " + childClassName + " to add").addTagValue("@return", "this");
            mutator.addParameter(childClassName, "value");
            ((MethodSource)((MethodSource)mutator.setPublic()).setName(singularName)).setReturnType(javaClass.getName()).setBody("this.subresources." + propName + ".add(value);\nreturn this;");
            AnnotationSource subresourceMeta = accessor.addAnnotation();
            subresourceMeta.setName("Subresource");
        }
        javaClass.addNestedType((JavaSource)subresourceClass);
    }

    private static JavaClassSource createSubresourceClass(ResourceMetaData resourceMetaData, JavaClassSource javaClass) {
        JavaClassSource subresourceClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)("class " + javaClass.getName() + "Resources" + " {}"));
        subresourceClass.setPackage(resourceMetaData.get(ResourceMetaData.PKG));
        subresourceClass.getJavaDoc().setText("Child mutators for " + javaClass.getName());
        subresourceClass.setPublic();
        ((FieldSource)((FieldSource)javaClass.addField().setPrivate()).setType(subresourceClass.getName()).setName("subresources")).setLiteralInitializer("new " + subresourceClass.getName() + "();");
        MethodSource subresourcesMethod = (MethodSource)((MethodSource)javaClass.addMethod().setName("subresources")).setPublic();
        subresourcesMethod.setReturnType(subresourceClass.getName());
        subresourcesMethod.setBody("return this.subresources;");
        javaClass.addImport("java.util.List");
        javaClass.addImport(Subresource.class);
        return subresourceClass;
    }

    public static void createSingletonChildAccessors(GeneratorScope scope, ResourceMetaData resourceMetaData, JavaClassSource javaClass) {
        ResourceDescription description = resourceMetaData.getDescription();
        Set<String> singletonNames = description.getSingletonChildrenTypes();
        for (String singletonName : singletonNames) {
            String[] split = singletonName.split("=");
            String type = split[0];
            String name = split[1];
            AddressTemplate childAddress = resourceMetaData.getAddress().append(type + "=" + name);
            JavaClassSource childClass = scope.getGenerated(childAddress);
            javaClass.addImport((JavaType)childClass);
            String propName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, name);
            ((FieldSource)javaClass.addField().setName(propName)).setType((JavaType)childClass).setPrivate();
            MethodSource accessor = javaClass.addMethod();
            String javaDoc = description.getChildDescription(type, name).getText();
            accessor.getJavaDoc().setText(javaDoc);
            ((MethodSource)((MethodSource)accessor.setPublic()).setName(propName)).setReturnType((JavaType)childClass).setBody("return this." + propName + ";");
            AnnotationSource subresourceMeta = accessor.addAnnotation();
            subresourceMeta.setName("Subresource");
            MethodSource mutator = javaClass.addMethod();
            mutator.getJavaDoc().setText(javaDoc);
            mutator.addParameter((JavaType)childClass, "value");
            ((MethodSource)((MethodSource)mutator.setPublic()).setName(propName)).setReturnType(javaClass.getName()).setBody("this." + propName + "=value;\nreturn this;");
        }
    }
}

