/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.apigen.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.wildfly.apigen.model.Operation;
import org.wildfly.apigen.model.ResourceAddress;

public class Composite
extends Operation {
    public Composite(Operation first, Operation ... rest) {
        super("composite", ResourceAddress.ROOT, new ModelNode(), null);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        operations.add(first);
        if (rest != null) {
            Collections.addAll(operations, rest);
        }
        this.addSteps(operations);
    }

    public Composite(List<Operation> operations) {
        super("composite", ResourceAddress.ROOT, new ModelNode(), null);
        this.addSteps(operations);
    }

    private void addSteps(List<Operation> operations) {
        assert (!operations.isEmpty()) : "Steps for a composite operation must not be empty";
        for (Operation operation : operations) {
            this.get("steps").add((ModelNode)operation);
        }
    }
}

