package org.wildfly.swarm.config.ejb3.subsystem.cache;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import java.util.List;
/**
 * A SFSB cache
 */
@Address("/subsystem=ejb3/cache=*")
public class Cache {

	private String key;
	private List<String> aliases;
	private String passivationStore;

	public Cache(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The aliases by which this cache may also be referenced
	 */
	@Binding(detypedName = "aliases")
	public List<String> aliases() {
		return this.aliases;
	}

	/**
	 * The aliases by which this cache may also be referenced
	 */
	public Cache aliases(List<String> value) {
		this.aliases = value;
		return this;
	}

	/**
	 * The passivation store used by this cache
	 */
	@Binding(detypedName = "passivation-store")
	public String passivationStore() {
		return this.passivationStore;
	}

	/**
	 * The passivation store used by this cache
	 */
	public Cache passivationStore(String value) {
		this.passivationStore = value;
		return this;
	}
}