package org.wildfly.swarm.config.ejb3.subsystem.clusterPassivationStore;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * A clustered passivation store
 */
@Address("/subsystem=ejb3/cluster-passivation-store=*")
public class ClusterPassivationStore {

	private String key;
	private String beanCache;
	private String cacheContainer;
	private String clientMappingsCache;
	private Long idleTimeout;
	private String idleTimeoutUnit;
	private Integer maxSize;
	private Boolean passivateEventsOnReplicate;

	public ClusterPassivationStore(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	@Binding(detypedName = "bean-cache")
	public String beanCache() {
		return this.beanCache;
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	public ClusterPassivationStore beanCache(String value) {
		this.beanCache = value;
		return this;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings caches
	 */
	@Binding(detypedName = "cache-container")
	public String cacheContainer() {
		return this.cacheContainer;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings caches
	 */
	public ClusterPassivationStore cacheContainer(String value) {
		this.cacheContainer = value;
		return this;
	}

	/**
	 * The name of the cache used to store client-mappings of the EJB remoting connector's socket-bindings
	 */
	@Binding(detypedName = "client-mappings-cache")
	public String clientMappingsCache() {
		return this.clientMappingsCache;
	}

	/**
	 * The name of the cache used to store client-mappings of the EJB remoting connector's socket-bindings
	 */
	public ClusterPassivationStore clientMappingsCache(String value) {
		this.clientMappingsCache = value;
		return this;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean will passivate
	 */
	@Binding(detypedName = "idle-timeout")
	public Long idleTimeout() {
		return this.idleTimeout;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean will passivate
	 */
	public ClusterPassivationStore idleTimeout(Long value) {
		this.idleTimeout = value;
		return this;
	}

	/**
	 * The unit of idle-timeout
	 */
	@Binding(detypedName = "idle-timeout-unit")
	public String idleTimeoutUnit() {
		return this.idleTimeoutUnit;
	}

	/**
	 * The unit of idle-timeout
	 */
	public ClusterPassivationStore idleTimeoutUnit(String value) {
		this.idleTimeoutUnit = value;
		return this;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@Binding(detypedName = "max-size")
	public Integer maxSize() {
		return this.maxSize;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	public ClusterPassivationStore maxSize(Integer value) {
		this.maxSize = value;
		return this;
	}

	/**
	 * Indicates whether replication should trigger passivation events on the bean
	 */
	@Binding(detypedName = "passivate-events-on-replicate")
	public Boolean passivateEventsOnReplicate() {
		return this.passivateEventsOnReplicate;
	}

	/**
	 * Indicates whether replication should trigger passivation events on the bean
	 */
	public ClusterPassivationStore passivateEventsOnReplicate(Boolean value) {
		this.passivateEventsOnReplicate = value;
		return this;
	}
}