package org.wildfly.swarm.config.ejb3.subsystem.remotingProfile.remotingEjbReceiver;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import java.util.List;
import org.wildfly.apigen.invocation.Subresource;
import org.wildfly.swarm.config.ejb3.subsystem.remotingProfile.remotingEjbReceiver.channelCreationOptions.ChannelCreationOptions;
/**
 * A remoting ejb receiver reference included in the profile
 */
@Address("/subsystem=ejb3/remoting-profile=*/remoting-ejb-receiver=*")
public class RemotingEjbReceiver {

	private String key;
	private Long connectTimeout;
	private String outboundConnectionRef;
	private RemotingEjbReceiverResources subresources = new RemotingEjbReceiverResources();

	public RemotingEjbReceiver(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Remoting ejb receiver connect timeout
	 */
	@Binding(detypedName = "connect-timeout")
	public Long connectTimeout() {
		return this.connectTimeout;
	}

	/**
	 * Remoting ejb receiver connect timeout
	 */
	public RemotingEjbReceiver connectTimeout(Long value) {
		this.connectTimeout = value;
		return this;
	}

	/**
	 * Name of outbound connection that will be used by the ejb receiver
	 */
	@Binding(detypedName = "outbound-connection-ref")
	public String outboundConnectionRef() {
		return this.outboundConnectionRef;
	}

	/**
	 * Name of outbound connection that will be used by the ejb receiver
	 */
	public RemotingEjbReceiver outboundConnectionRef(String value) {
		this.outboundConnectionRef = value;
		return this;
	}

	public RemotingEjbReceiverResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ChannelCreationOptions objects to this subresource
	 * @return this
	 * @param value List of ChannelCreationOptions objects.
	 */
	public RemotingEjbReceiver channelCreationOptions(
			List<ChannelCreationOptions> value) {
		this.subresources.channelCreationOptions.addAll(value);
		return this;
	}

	/**
	 * Add the ChannelCreationOptions object to the list of subresources
	 * @param value The ChannelCreationOptions to add
	 * @return this
	 */
	public RemotingEjbReceiver channelCreationOptions(
			ChannelCreationOptions value) {
		this.subresources.channelCreationOptions.add(value);
		return this;
	}

	/**
	 * Child mutators for RemotingEjbReceiver
	 */
	public class RemotingEjbReceiverResources {
		/**
		 * The options that will be used during the EJB remote channel creation
		 */
		private List<ChannelCreationOptions> channelCreationOptions = new java.util.ArrayList<>();

		/**
		 * Get the list of ChannelCreationOptions resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ChannelCreationOptions> channelCreationOptions() {
			return this.channelCreationOptions;
		}
	}
}