package org.wildfly.swarm.config.ejb3.subsystem.service;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * The EJB3 Asynchronous Invocation Service
 */
@Address("/subsystem=ejb3/service=async")
@Implicit
public class Async {

	private String key;
	private String threadPoolName;

	public Async() {
		this.key = "async";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the thread pool which handles asynchronous invocations
	 */
	@Binding(detypedName = "thread-pool-name")
	public String threadPoolName() {
		return this.threadPoolName;
	}

	/**
	 * The name of the thread pool which handles asynchronous invocations
	 */
	public Async threadPoolName(String value) {
		this.threadPoolName = value;
		return this;
	}
}