package org.wildfly.swarm.config.ejb3.subsystem.service;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * The IIOP service
 */
@Address("/subsystem=ejb3/service=iiop")
@Implicit
public class Iiop {

	private String key;
	private Boolean enableByDefault;
	private Boolean useQualifiedName;

	public Iiop() {
		this.key = "iiop";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * If this is true EJB's will be exposed over IIOP by default, otherwise it needs to be explicitly enabled in the deployment descriptor
	 */
	@Binding(detypedName = "enable-by-default")
	public Boolean enableByDefault() {
		return this.enableByDefault;
	}

	/**
	 * If this is true EJB's will be exposed over IIOP by default, otherwise it needs to be explicitly enabled in the deployment descriptor
	 */
	public Iiop enableByDefault(Boolean value) {
		this.enableByDefault = value;
		return this;
	}

	/**
	 * If true EJB names will be bound into the naming service with the application and module name prepended to the name (e.g. myapp/mymodule/MyEjb)
	 */
	@Binding(detypedName = "use-qualified-name")
	public Boolean useQualifiedName() {
		return this.useQualifiedName;
	}

	/**
	 * If true EJB names will be bound into the naming service with the application and module name prepended to the name (e.g. myapp/mymodule/MyEjb)
	 */
	public Iiop useQualifiedName(Boolean value) {
		this.useQualifiedName = value;
		return this;
	}
}