package org.wildfly.swarm.config.ejb3.subsystem.service;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import java.util.List;
import org.wildfly.apigen.invocation.Subresource;
import org.wildfly.swarm.config.ejb3.subsystem.service.fileDataStore.FileDataStore;
import org.wildfly.swarm.config.ejb3.subsystem.service.databaseDataStore.DatabaseDataStore;
/**
 * The EJB timer service
 */
@Address("/subsystem=ejb3/service=timer-service")
@Implicit
public class TimerService {

	private String key;
	private String defaultDataStore;
	private String threadPoolName;
	private TimerServiceResources subresources = new TimerServiceResources();

	public TimerService() {
		this.key = "timer-service";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The default data store used for persistent timers
	 */
	@Binding(detypedName = "default-data-store")
	public String defaultDataStore() {
		return this.defaultDataStore;
	}

	/**
	 * The default data store used for persistent timers
	 */
	public TimerService defaultDataStore(String value) {
		this.defaultDataStore = value;
		return this;
	}

	/**
	 * The name of the thread pool used to run timer service invocations
	 */
	@Binding(detypedName = "thread-pool-name")
	public String threadPoolName() {
		return this.threadPoolName;
	}

	/**
	 * The name of the thread pool used to run timer service invocations
	 */
	public TimerService threadPoolName(String value) {
		this.threadPoolName = value;
		return this;
	}

	public TimerServiceResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all FileDataStore objects to this subresource
	 * @return this
	 * @param value List of FileDataStore objects.
	 */
	public TimerService fileDataStores(List<FileDataStore> value) {
		this.subresources.fileDataStores.addAll(value);
		return this;
	}

	/**
	 * Add the FileDataStore object to the list of subresources
	 * @param value The FileDataStore to add
	 * @return this
	 */
	public TimerService fileDataStore(FileDataStore value) {
		this.subresources.fileDataStores.add(value);
		return this;
	}

	/**
	 * Add all DatabaseDataStore objects to this subresource
	 * @return this
	 * @param value List of DatabaseDataStore objects.
	 */
	public TimerService databaseDataStores(List<DatabaseDataStore> value) {
		this.subresources.databaseDataStores.addAll(value);
		return this;
	}

	/**
	 * Add the DatabaseDataStore object to the list of subresources
	 * @param value The DatabaseDataStore to add
	 * @return this
	 */
	public TimerService databaseDataStore(DatabaseDataStore value) {
		this.subresources.databaseDataStores.add(value);
		return this;
	}

	/**
	 * Child mutators for TimerService
	 */
	public class TimerServiceResources {
		/**
		 * A JVM local file store that stores persistent EJB timers
		 */
		private List<FileDataStore> fileDataStores = new java.util.ArrayList<>();
		/**
		 * An database based store for persistent EJB timers.
		 */
		private List<DatabaseDataStore> databaseDataStores = new java.util.ArrayList<>();

		/**
		 * Get the list of FileDataStore resources
		 * @return the list of resources
		 */
		@Subresource
		public List<FileDataStore> fileDataStores() {
			return this.fileDataStores;
		}

		/**
		 * Get the list of DatabaseDataStore resources
		 * @return the list of resources
		 */
		@Subresource
		public List<DatabaseDataStore> databaseDataStores() {
			return this.databaseDataStores;
		}
	}
}