package org.wildfly.swarm.config.ejb3.subsystem.service.channelCreationOptions;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * The options that will be used during the EJB remote channel creation
 */
@Address("/subsystem=ejb3/service=remote/channel-creation-options=*")
public class ChannelCreationOptions {

	private String key;
	private String type;
	private String value;

	public ChannelCreationOptions(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The type of the channel creation option
	 */
	@Binding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * The type of the channel creation option
	 */
	public ChannelCreationOptions type(String value) {
		this.type = value;
		return this;
	}

	/**
	 * The value for the EJB remote channel creation option
	 */
	@Binding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The value for the EJB remote channel creation option
	 */
	public ChannelCreationOptions value(String value) {
		this.value = value;
		return this;
	}
}