package org.wildfly.swarm.config.ejb3.subsystem.service.fileDataStore;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * A JVM local file store that stores persistent EJB timers
 */
@Address("/subsystem=ejb3/service=timer-service/file-data-store=*")
public class FileDataStore {

	private String key;
	private String path;
	private String relativeTo;

	public FileDataStore(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The directory to store persistent timer information in
	 */
	@Binding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * The directory to store persistent timer information in
	 */
	public FileDataStore path(String value) {
		this.path = value;
		return this;
	}

	/**
	 * The relative path that is used to resolve the timer data store location
	 */
	@Binding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The relative path that is used to resolve the timer data store location
	 */
	public FileDataStore relativeTo(String value) {
		this.relativeTo = value;
		return this;
	}
}