package org.wildfly.swarm.config.ejb3.subsystem.strictMaxBeanInstancePool;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * A bean instance pool with a strict upper limit
 */
@Address("/subsystem=ejb3/strict-max-bean-instance-pool=*")
public class StrictMaxBeanInstancePool {

	private String key;
	private Integer maxPoolSize;
	private Long timeout;
	private String timeoutUnit;

	public StrictMaxBeanInstancePool(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The maximum number of bean instances that the pool can hold at a given point in time
	 */
	@Binding(detypedName = "max-pool-size")
	public Integer maxPoolSize() {
		return this.maxPoolSize;
	}

	/**
	 * The maximum number of bean instances that the pool can hold at a given point in time
	 */
	public StrictMaxBeanInstancePool maxPoolSize(Integer value) {
		this.maxPoolSize = value;
		return this;
	}

	/**
	 * The maximum amount of time to wait for a bean instance to be available from the pool
	 */
	@Binding(detypedName = "timeout")
	public Long timeout() {
		return this.timeout;
	}

	/**
	 * The maximum amount of time to wait for a bean instance to be available from the pool
	 */
	public StrictMaxBeanInstancePool timeout(Long value) {
		this.timeout = value;
		return this;
	}

	/**
	 * The instance acquisition timeout unit
	 */
	@Binding(detypedName = "timeout-unit")
	public String timeoutUnit() {
		return this.timeoutUnit;
	}

	/**
	 * The instance acquisition timeout unit
	 */
	public StrictMaxBeanInstancePool timeoutUnit(String value) {
		this.timeoutUnit = value;
		return this;
	}
}