package org.wildfly.swarm.config.ejb3.subsystem.threadPool;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import java.util.Map;
/**
 * A thread pool executor with an unbounded queue.  Such a thread pool has a core size and a queue with no upper bound.  When a task is submitted, if the number of running threads is less than the core size, a new thread is created.  Otherwise, the task is placed in queue.  If too many tasks are allowed to be submitted to this type of executor, an out of memory condition may occur.
 */
@Address("/subsystem=ejb3/thread-pool=*")
public class ThreadPool {

	private String key;
	private Integer activeCount;
	private Integer completedTaskCount;
	private Integer currentThreadCount;
	private Map keepaliveTime;
	private Integer largestThreadCount;
	private Integer maxThreads;
	private String name;
	private Integer queueSize;
	private Integer rejectedCount;
	private Integer taskCount;
	private String threadFactory;

	public ThreadPool(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The approximate number of threads that are actively executing tasks.
	 */
	@Binding(detypedName = "active-count")
	public Integer activeCount() {
		return this.activeCount;
	}

	/**
	 * The approximate number of threads that are actively executing tasks.
	 */
	public ThreadPool activeCount(Integer value) {
		this.activeCount = value;
		return this;
	}

	/**
	 * The approximate total number of tasks that have completed execution.
	 */
	@Binding(detypedName = "completed-task-count")
	public Integer completedTaskCount() {
		return this.completedTaskCount;
	}

	/**
	 * The approximate total number of tasks that have completed execution.
	 */
	public ThreadPool completedTaskCount(Integer value) {
		this.completedTaskCount = value;
		return this;
	}

	/**
	 * The current number of threads in the pool.
	 */
	@Binding(detypedName = "current-thread-count")
	public Integer currentThreadCount() {
		return this.currentThreadCount;
	}

	/**
	 * The current number of threads in the pool.
	 */
	public ThreadPool currentThreadCount(Integer value) {
		this.currentThreadCount = value;
		return this;
	}

	/**
	 * Used to specify the amount of time that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@Binding(detypedName = "keepalive-time")
	public Map keepaliveTime() {
		return this.keepaliveTime;
	}

	/**
	 * Used to specify the amount of time that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	public ThreadPool keepaliveTime(Map value) {
		this.keepaliveTime = value;
		return this;
	}

	/**
	 * The largest number of threads that have ever simultaneously been in the pool.
	 */
	@Binding(detypedName = "largest-thread-count")
	public Integer largestThreadCount() {
		return this.largestThreadCount;
	}

	/**
	 * The largest number of threads that have ever simultaneously been in the pool.
	 */
	public ThreadPool largestThreadCount(Integer value) {
		this.largestThreadCount = value;
		return this;
	}

	/**
	 * The maximum thread pool size.
	 */
	@Binding(detypedName = "max-threads")
	public Integer maxThreads() {
		return this.maxThreads;
	}

	/**
	 * The maximum thread pool size.
	 */
	public ThreadPool maxThreads(Integer value) {
		this.maxThreads = value;
		return this;
	}

	/**
	 * The name of the thread pool.
	 */
	@Binding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the thread pool.
	 */
	public ThreadPool name(String value) {
		this.name = value;
		return this;
	}

	/**
	 * The queue size.
	 */
	@Binding(detypedName = "queue-size")
	public Integer queueSize() {
		return this.queueSize;
	}

	/**
	 * The queue size.
	 */
	public ThreadPool queueSize(Integer value) {
		this.queueSize = value;
		return this;
	}

	/**
	 * The number of tasks that have been rejected.
	 */
	@Binding(detypedName = "rejected-count")
	public Integer rejectedCount() {
		return this.rejectedCount;
	}

	/**
	 * The number of tasks that have been rejected.
	 */
	public ThreadPool rejectedCount(Integer value) {
		this.rejectedCount = value;
		return this;
	}

	/**
	 * The approximate total number of tasks that have ever been scheduled for execution.
	 */
	@Binding(detypedName = "task-count")
	public Integer taskCount() {
		return this.taskCount;
	}

	/**
	 * The approximate total number of tasks that have ever been scheduled for execution.
	 */
	public ThreadPool taskCount(Integer value) {
		this.taskCount = value;
		return this;
	}

	/**
	 * Specifies the name of a specific thread factory to use to create worker threads. If not defined an appropriate default thread factory will be used.
	 */
	@Binding(detypedName = "thread-factory")
	public String threadFactory() {
		return this.threadFactory;
	}

	/**
	 * Specifies the name of a specific thread factory to use to create worker threads. If not defined an appropriate default thread factory will be used.
	 */
	public ThreadPool threadFactory(String value) {
		this.threadFactory = value;
		return this;
	}
}