package org.wildfly.swarm.config.io.subsystem.worker;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * Defines workers
 */
@Address("/subsystem=io/worker=*")
public class Worker {

	private String key;
	private Integer ioThreads;
	private Long stackSize;
	private Integer taskCoreThreads;
	private Integer taskKeepalive;
	private Integer taskMaxThreads;

	public Worker(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Number of IO threads to use
	 */
	@Binding(detypedName = "io-threads")
	public Integer ioThreads() {
		return this.ioThreads;
	}

	/**
	 * Number of IO threads to use
	 */
	public Worker ioThreads(Integer value) {
		this.ioThreads = value;
		return this;
	}

	/**
	 * stack-size
	 */
	@Binding(detypedName = "stack-size")
	public Long stackSize() {
		return this.stackSize;
	}

	/**
	 * stack-size
	 */
	public Worker stackSize(Long value) {
		this.stackSize = value;
		return this;
	}

	/**
	 * task-core-threads
	 */
	@Binding(detypedName = "task-core-threads")
	public Integer taskCoreThreads() {
		return this.taskCoreThreads;
	}

	/**
	 * task-core-threads
	 */
	public Worker taskCoreThreads(Integer value) {
		this.taskCoreThreads = value;
		return this;
	}

	/**
	 * task-keepalive
	 */
	@Binding(detypedName = "task-keepalive")
	public Integer taskKeepalive() {
		return this.taskKeepalive;
	}

	/**
	 * task-keepalive
	 */
	public Worker taskKeepalive(Integer value) {
		this.taskKeepalive = value;
		return this;
	}

	/**
	 * task-max-threads
	 */
	@Binding(detypedName = "task-max-threads")
	public Integer taskMaxThreads() {
		return this.taskMaxThreads;
	}

	/**
	 * task-max-threads
	 */
	public Worker taskMaxThreads(Integer value) {
		this.taskMaxThreads = value;
		return this;
	}
}