/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.datasources;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Subresource;
import org.wildfly.swarm.config.datasources.subsystem.dataSource.DataSource;
import org.wildfly.swarm.config.datasources.subsystem.jdbcDriver.JdbcDriver;
import org.wildfly.swarm.config.datasources.subsystem.xaDataSource.XaDataSource;

@Address(value="/subsystem=datasources")
@Implicit
public class Datasources {
    private String key = "datasources";
    private List<Map> installedDrivers;
    private DatasourcesResources subresources = new DatasourcesResources();

    public String getKey() {
        return this.key;
    }

    @Binding(detypedName="installed-drivers")
    public List<Map> installedDrivers() {
        return this.installedDrivers;
    }

    public Datasources installedDrivers(List<Map> value) {
        this.installedDrivers = value;
        return this;
    }

    public DatasourcesResources subresources() {
        return this.subresources;
    }

    public Datasources jdbcDrivers(List<JdbcDriver> value) {
        this.subresources.jdbcDrivers.addAll(value);
        return this;
    }

    public Datasources jdbcDriver(JdbcDriver value) {
        this.subresources.jdbcDrivers.add(value);
        return this;
    }

    public Datasources xaDataSources(List<XaDataSource> value) {
        this.subresources.xaDataSources.addAll(value);
        return this;
    }

    public Datasources xaDataSource(XaDataSource value) {
        this.subresources.xaDataSources.add(value);
        return this;
    }

    public Datasources dataSources(List<DataSource> value) {
        this.subresources.dataSources.addAll(value);
        return this;
    }

    public Datasources dataSource(DataSource value) {
        this.subresources.dataSources.add(value);
        return this;
    }

    public class DatasourcesResources {
        private List<JdbcDriver> jdbcDrivers = new ArrayList<JdbcDriver>();
        private List<XaDataSource> xaDataSources = new ArrayList<XaDataSource>();
        private List<DataSource> dataSources = new ArrayList<DataSource>();

        @Subresource
        public List<JdbcDriver> jdbcDrivers() {
            return this.jdbcDrivers;
        }

        @Subresource
        public List<XaDataSource> xaDataSources() {
            return this.xaDataSources;
        }

        @Subresource
        public List<DataSource> dataSources() {
            return this.dataSources;
        }
    }
}

