/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.logging;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Subresource;
import org.wildfly.swarm.config.logging.subsystem.asyncHandler.AsyncHandler;
import org.wildfly.swarm.config.logging.subsystem.consoleHandler.ConsoleHandler;
import org.wildfly.swarm.config.logging.subsystem.customFormatter.CustomFormatter;
import org.wildfly.swarm.config.logging.subsystem.customHandler.CustomHandler;
import org.wildfly.swarm.config.logging.subsystem.fileHandler.FileHandler;
import org.wildfly.swarm.config.logging.subsystem.logFile.LogFile;
import org.wildfly.swarm.config.logging.subsystem.logger.Logger;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.LoggingProfile;
import org.wildfly.swarm.config.logging.subsystem.patternFormatter.PatternFormatter;
import org.wildfly.swarm.config.logging.subsystem.periodicRotatingFileHandler.PeriodicRotatingFileHandler;
import org.wildfly.swarm.config.logging.subsystem.periodicSizeRotatingFileHandler.PeriodicSizeRotatingFileHandler;
import org.wildfly.swarm.config.logging.subsystem.rootLogger.Root;
import org.wildfly.swarm.config.logging.subsystem.sizeRotatingFileHandler.SizeRotatingFileHandler;
import org.wildfly.swarm.config.logging.subsystem.syslogHandler.SyslogHandler;

@Address(value="/subsystem=logging")
@Implicit
public class Logging {
    private String key = "logging";
    private Boolean addLoggingApiDependencies;
    private Boolean useDeploymentLoggingConfig;
    private LoggingResources subresources = new LoggingResources();
    private Root root;

    public String getKey() {
        return this.key;
    }

    @Binding(detypedName="add-logging-api-dependencies")
    public Boolean addLoggingApiDependencies() {
        return this.addLoggingApiDependencies;
    }

    public Logging addLoggingApiDependencies(Boolean value) {
        this.addLoggingApiDependencies = value;
        return this;
    }

    @Binding(detypedName="use-deployment-logging-config")
    public Boolean useDeploymentLoggingConfig() {
        return this.useDeploymentLoggingConfig;
    }

    public Logging useDeploymentLoggingConfig(Boolean value) {
        this.useDeploymentLoggingConfig = value;
        return this;
    }

    public LoggingResources subresources() {
        return this.subresources;
    }

    public Logging periodicRotatingFileHandlers(List<PeriodicRotatingFileHandler> value) {
        this.subresources.periodicRotatingFileHandlers.addAll(value);
        return this;
    }

    public Logging periodicRotatingFileHandler(PeriodicRotatingFileHandler value) {
        this.subresources.periodicRotatingFileHandlers.add(value);
        return this;
    }

    public Logging loggers(List<Logger> value) {
        this.subresources.loggers.addAll(value);
        return this;
    }

    public Logging logger(Logger value) {
        this.subresources.loggers.add(value);
        return this;
    }

    public Logging asyncHandlers(List<AsyncHandler> value) {
        this.subresources.asyncHandlers.addAll(value);
        return this;
    }

    public Logging asyncHandler(AsyncHandler value) {
        this.subresources.asyncHandlers.add(value);
        return this;
    }

    public Logging fileHandlers(List<FileHandler> value) {
        this.subresources.fileHandlers.addAll(value);
        return this;
    }

    public Logging fileHandler(FileHandler value) {
        this.subresources.fileHandlers.add(value);
        return this;
    }

    public Logging sizeRotatingFileHandlers(List<SizeRotatingFileHandler> value) {
        this.subresources.sizeRotatingFileHandlers.addAll(value);
        return this;
    }

    public Logging sizeRotatingFileHandler(SizeRotatingFileHandler value) {
        this.subresources.sizeRotatingFileHandlers.add(value);
        return this;
    }

    public Logging syslogHandlers(List<SyslogHandler> value) {
        this.subresources.syslogHandlers.addAll(value);
        return this;
    }

    public Logging syslogHandler(SyslogHandler value) {
        this.subresources.syslogHandlers.add(value);
        return this;
    }

    public Logging loggingProfiles(List<LoggingProfile> value) {
        this.subresources.loggingProfiles.addAll(value);
        return this;
    }

    public Logging loggingProfile(LoggingProfile value) {
        this.subresources.loggingProfiles.add(value);
        return this;
    }

    public Logging customFormatters(List<CustomFormatter> value) {
        this.subresources.customFormatters.addAll(value);
        return this;
    }

    public Logging customFormatter(CustomFormatter value) {
        this.subresources.customFormatters.add(value);
        return this;
    }

    public Logging periodicSizeRotatingFileHandlers(List<PeriodicSizeRotatingFileHandler> value) {
        this.subresources.periodicSizeRotatingFileHandlers.addAll(value);
        return this;
    }

    public Logging periodicSizeRotatingFileHandler(PeriodicSizeRotatingFileHandler value) {
        this.subresources.periodicSizeRotatingFileHandlers.add(value);
        return this;
    }

    public Logging consoleHandlers(List<ConsoleHandler> value) {
        this.subresources.consoleHandlers.addAll(value);
        return this;
    }

    public Logging consoleHandler(ConsoleHandler value) {
        this.subresources.consoleHandlers.add(value);
        return this;
    }

    public Logging logFiles(List<LogFile> value) {
        this.subresources.logFiles.addAll(value);
        return this;
    }

    public Logging logFile(LogFile value) {
        this.subresources.logFiles.add(value);
        return this;
    }

    public Logging patternFormatters(List<PatternFormatter> value) {
        this.subresources.patternFormatters.addAll(value);
        return this;
    }

    public Logging patternFormatter(PatternFormatter value) {
        this.subresources.patternFormatters.add(value);
        return this;
    }

    public Logging customHandlers(List<CustomHandler> value) {
        this.subresources.customHandlers.addAll(value);
        return this;
    }

    public Logging customHandler(CustomHandler value) {
        this.subresources.customHandlers.add(value);
        return this;
    }

    @Subresource
    public Root root() {
        return this.root;
    }

    public Logging root(Root value) {
        this.root = value;
        return this;
    }

    public class LoggingResources {
        private List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers = new ArrayList<PeriodicRotatingFileHandler>();
        private List<Logger> loggers = new ArrayList<Logger>();
        private List<AsyncHandler> asyncHandlers = new ArrayList<AsyncHandler>();
        private List<FileHandler> fileHandlers = new ArrayList<FileHandler>();
        private List<SizeRotatingFileHandler> sizeRotatingFileHandlers = new ArrayList<SizeRotatingFileHandler>();
        private List<SyslogHandler> syslogHandlers = new ArrayList<SyslogHandler>();
        private List<LoggingProfile> loggingProfiles = new ArrayList<LoggingProfile>();
        private List<CustomFormatter> customFormatters = new ArrayList<CustomFormatter>();
        private List<PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers = new ArrayList<PeriodicSizeRotatingFileHandler>();
        private List<ConsoleHandler> consoleHandlers = new ArrayList<ConsoleHandler>();
        private List<LogFile> logFiles = new ArrayList<LogFile>();
        private List<PatternFormatter> patternFormatters = new ArrayList<PatternFormatter>();
        private List<CustomHandler> customHandlers = new ArrayList<CustomHandler>();

        @Subresource
        public List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers() {
            return this.periodicRotatingFileHandlers;
        }

        @Subresource
        public List<Logger> loggers() {
            return this.loggers;
        }

        @Subresource
        public List<AsyncHandler> asyncHandlers() {
            return this.asyncHandlers;
        }

        @Subresource
        public List<FileHandler> fileHandlers() {
            return this.fileHandlers;
        }

        @Subresource
        public List<SizeRotatingFileHandler> sizeRotatingFileHandlers() {
            return this.sizeRotatingFileHandlers;
        }

        @Subresource
        public List<SyslogHandler> syslogHandlers() {
            return this.syslogHandlers;
        }

        @Subresource
        public List<LoggingProfile> loggingProfiles() {
            return this.loggingProfiles;
        }

        @Subresource
        public List<CustomFormatter> customFormatters() {
            return this.customFormatters;
        }

        @Subresource
        public List<PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers() {
            return this.periodicSizeRotatingFileHandlers;
        }

        @Subresource
        public List<ConsoleHandler> consoleHandlers() {
            return this.consoleHandlers;
        }

        @Subresource
        public List<LogFile> logFiles() {
            return this.logFiles;
        }

        @Subresource
        public List<PatternFormatter> patternFormatters() {
            return this.patternFormatters;
        }

        @Subresource
        public List<CustomHandler> customHandlers() {
            return this.customHandlers;
        }
    }
}

