/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.logging.subsystem.loggingProfile;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Subresource;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.asyncHandler.AsyncHandler;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.consoleHandler.ConsoleHandler;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.customFormatter.CustomFormatter;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.customHandler.CustomHandler;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.fileHandler.FileHandler;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.logFile.LogFile;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.logger.Logger;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.patternFormatter.PatternFormatter;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.periodicRotatingFileHandler.PeriodicRotatingFileHandler;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.periodicSizeRotatingFileHandler.PeriodicSizeRotatingFileHandler;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.rootLogger.Root;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.sizeRotatingFileHandler.SizeRotatingFileHandler;
import org.wildfly.swarm.config.logging.subsystem.loggingProfile.syslogHandler.SyslogHandler;

@Address(value="/subsystem=logging/logging-profile=*")
public class LoggingProfile {
    private String key;
    private LoggingProfileResources subresources = new LoggingProfileResources();
    private Root root;

    public LoggingProfile(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public LoggingProfileResources subresources() {
        return this.subresources;
    }

    public LoggingProfile periodicRotatingFileHandlers(List<PeriodicRotatingFileHandler> value) {
        this.subresources.periodicRotatingFileHandlers.addAll(value);
        return this;
    }

    public LoggingProfile periodicRotatingFileHandler(PeriodicRotatingFileHandler value) {
        this.subresources.periodicRotatingFileHandlers.add(value);
        return this;
    }

    public LoggingProfile customFormatters(List<CustomFormatter> value) {
        this.subresources.customFormatters.addAll(value);
        return this;
    }

    public LoggingProfile customFormatter(CustomFormatter value) {
        this.subresources.customFormatters.add(value);
        return this;
    }

    public LoggingProfile periodicSizeRotatingFileHandlers(List<PeriodicSizeRotatingFileHandler> value) {
        this.subresources.periodicSizeRotatingFileHandlers.addAll(value);
        return this;
    }

    public LoggingProfile periodicSizeRotatingFileHandler(PeriodicSizeRotatingFileHandler value) {
        this.subresources.periodicSizeRotatingFileHandlers.add(value);
        return this;
    }

    public LoggingProfile consoleHandlers(List<ConsoleHandler> value) {
        this.subresources.consoleHandlers.addAll(value);
        return this;
    }

    public LoggingProfile consoleHandler(ConsoleHandler value) {
        this.subresources.consoleHandlers.add(value);
        return this;
    }

    public LoggingProfile loggers(List<Logger> value) {
        this.subresources.loggers.addAll(value);
        return this;
    }

    public LoggingProfile logger(Logger value) {
        this.subresources.loggers.add(value);
        return this;
    }

    public LoggingProfile asyncHandlers(List<AsyncHandler> value) {
        this.subresources.asyncHandlers.addAll(value);
        return this;
    }

    public LoggingProfile asyncHandler(AsyncHandler value) {
        this.subresources.asyncHandlers.add(value);
        return this;
    }

    public LoggingProfile fileHandlers(List<FileHandler> value) {
        this.subresources.fileHandlers.addAll(value);
        return this;
    }

    public LoggingProfile fileHandler(FileHandler value) {
        this.subresources.fileHandlers.add(value);
        return this;
    }

    public LoggingProfile logFiles(List<LogFile> value) {
        this.subresources.logFiles.addAll(value);
        return this;
    }

    public LoggingProfile logFile(LogFile value) {
        this.subresources.logFiles.add(value);
        return this;
    }

    public LoggingProfile patternFormatters(List<PatternFormatter> value) {
        this.subresources.patternFormatters.addAll(value);
        return this;
    }

    public LoggingProfile patternFormatter(PatternFormatter value) {
        this.subresources.patternFormatters.add(value);
        return this;
    }

    public LoggingProfile sizeRotatingFileHandlers(List<SizeRotatingFileHandler> value) {
        this.subresources.sizeRotatingFileHandlers.addAll(value);
        return this;
    }

    public LoggingProfile sizeRotatingFileHandler(SizeRotatingFileHandler value) {
        this.subresources.sizeRotatingFileHandlers.add(value);
        return this;
    }

    public LoggingProfile syslogHandlers(List<SyslogHandler> value) {
        this.subresources.syslogHandlers.addAll(value);
        return this;
    }

    public LoggingProfile syslogHandler(SyslogHandler value) {
        this.subresources.syslogHandlers.add(value);
        return this;
    }

    public LoggingProfile customHandlers(List<CustomHandler> value) {
        this.subresources.customHandlers.addAll(value);
        return this;
    }

    public LoggingProfile customHandler(CustomHandler value) {
        this.subresources.customHandlers.add(value);
        return this;
    }

    @Subresource
    public Root root() {
        return this.root;
    }

    public LoggingProfile root(Root value) {
        this.root = value;
        return this;
    }

    public class LoggingProfileResources {
        private List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers = new ArrayList<PeriodicRotatingFileHandler>();
        private List<CustomFormatter> customFormatters = new ArrayList<CustomFormatter>();
        private List<PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers = new ArrayList<PeriodicSizeRotatingFileHandler>();
        private List<ConsoleHandler> consoleHandlers = new ArrayList<ConsoleHandler>();
        private List<Logger> loggers = new ArrayList<Logger>();
        private List<AsyncHandler> asyncHandlers = new ArrayList<AsyncHandler>();
        private List<FileHandler> fileHandlers = new ArrayList<FileHandler>();
        private List<LogFile> logFiles = new ArrayList<LogFile>();
        private List<PatternFormatter> patternFormatters = new ArrayList<PatternFormatter>();
        private List<SizeRotatingFileHandler> sizeRotatingFileHandlers = new ArrayList<SizeRotatingFileHandler>();
        private List<SyslogHandler> syslogHandlers = new ArrayList<SyslogHandler>();
        private List<CustomHandler> customHandlers = new ArrayList<CustomHandler>();

        @Subresource
        public List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers() {
            return this.periodicRotatingFileHandlers;
        }

        @Subresource
        public List<CustomFormatter> customFormatters() {
            return this.customFormatters;
        }

        @Subresource
        public List<PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers() {
            return this.periodicSizeRotatingFileHandlers;
        }

        @Subresource
        public List<ConsoleHandler> consoleHandlers() {
            return this.consoleHandlers;
        }

        @Subresource
        public List<Logger> loggers() {
            return this.loggers;
        }

        @Subresource
        public List<AsyncHandler> asyncHandlers() {
            return this.asyncHandlers;
        }

        @Subresource
        public List<FileHandler> fileHandlers() {
            return this.fileHandlers;
        }

        @Subresource
        public List<LogFile> logFiles() {
            return this.logFiles;
        }

        @Subresource
        public List<PatternFormatter> patternFormatters() {
            return this.patternFormatters;
        }

        @Subresource
        public List<SizeRotatingFileHandler> sizeRotatingFileHandlers() {
            return this.sizeRotatingFileHandlers;
        }

        @Subresource
        public List<SyslogHandler> syslogHandlers() {
            return this.syslogHandlers;
        }

        @Subresource
        public List<CustomHandler> customHandlers() {
            return this.customHandlers;
        }
    }
}

