package org.wildfly.swarm.config.ejb3.subsystem.passivationStore;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * A passivation store
 */
@Address("/subsystem=ejb3/passivation-store=*")
public class PassivationStore<T extends PassivationStore> {

	private String key;
	private String beanCache;
	private String cacheContainer;
	private Integer maxSize;

	public PassivationStore(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	@Binding(detypedName = "bean-cache")
	public String beanCache() {
		return this.beanCache;
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	@SuppressWarnings("unchecked")
	public T beanCache(String value) {
		this.beanCache = value;
		return (T) this;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings caches
	 */
	@Binding(detypedName = "cache-container")
	public String cacheContainer() {
		return this.cacheContainer;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings caches
	 */
	@SuppressWarnings("unchecked")
	public T cacheContainer(String value) {
		this.cacheContainer = value;
		return (T) this;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@Binding(detypedName = "max-size")
	public Integer maxSize() {
		return this.maxSize;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@SuppressWarnings("unchecked")
	public T maxSize(Integer value) {
		this.maxSize = value;
		return (T) this;
	}
}