package org.wildfly.swarm.config.ejb3.subsystem.remotingProfile;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import java.util.List;
import org.wildfly.apigen.invocation.Subresource;
import org.wildfly.swarm.config.ejb3.subsystem.remotingProfile.remotingEjbReceiver.RemotingEjbReceiver;
/**
 * A remoting profile
 */
@Address("/subsystem=ejb3/remoting-profile=*")
public class RemotingProfile<T extends RemotingProfile> {

	private String key;
	private Boolean excludeLocalReceiver;
	private Boolean localReceiverPassByValue;
	private RemotingProfileResources subresources = new RemotingProfileResources();

	public RemotingProfile(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * If set no local receiver is used in this profile
	 */
	@Binding(detypedName = "exclude-local-receiver")
	public Boolean excludeLocalReceiver() {
		return this.excludeLocalReceiver;
	}

	/**
	 * If set no local receiver is used in this profile
	 */
	@SuppressWarnings("unchecked")
	public T excludeLocalReceiver(Boolean value) {
		this.excludeLocalReceiver = value;
		return (T) this;
	}

	/**
	 * If set local receiver will pass ejb beans by value
	 */
	@Binding(detypedName = "local-receiver-pass-by-value")
	public Boolean localReceiverPassByValue() {
		return this.localReceiverPassByValue;
	}

	/**
	 * If set local receiver will pass ejb beans by value
	 */
	@SuppressWarnings("unchecked")
	public T localReceiverPassByValue(Boolean value) {
		this.localReceiverPassByValue = value;
		return (T) this;
	}

	public RemotingProfileResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all RemotingEjbReceiver objects to this subresource
	 * @return this
	 * @param value List of RemotingEjbReceiver objects.
	 */
	@SuppressWarnings("unchecked")
	public T remotingEjbReceivers(List<RemotingEjbReceiver> value) {
		this.subresources.remotingEjbReceivers.addAll(value);
		return (T) this;
	}

	/**
	 * Add the RemotingEjbReceiver object to the list of subresources
	 * @param value The RemotingEjbReceiver to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remotingEjbReceiver(RemotingEjbReceiver value) {
		this.subresources.remotingEjbReceivers.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for RemotingProfile
	 */
	public class RemotingProfileResources {
		/**
		 * A remoting ejb receiver reference included in the profile
		 */
		private List<RemotingEjbReceiver> remotingEjbReceivers = new java.util.ArrayList<>();

		/**
		 * Get the list of RemotingEjbReceiver resources
		 * @return the list of resources
		 */
		@Subresource
		public List<RemotingEjbReceiver> remotingEjbReceivers() {
			return this.remotingEjbReceivers;
		}
	}
}