package org.wildfly.swarm.config.ejb3.subsystem.filePassivationStore;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * A file system based passivation store
 */
@Address("/subsystem=ejb3/file-passivation-store=*")
public class FilePassivationStore<T extends FilePassivationStore> {

	private String key;
	private String groupsPath;
	private Long idleTimeout;
	private String idleTimeoutUnit;
	private Integer maxSize;
	private String relativeTo;
	private String sessionsPath;
	private Long subdirectoryCount;

	public FilePassivationStore(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The subdirectory within the path specified by relative-to in which to store passivated bean groups
	 */
	@Binding(detypedName = "groups-path")
	public String groupsPath() {
		return this.groupsPath;
	}

	/**
	 * The subdirectory within the path specified by relative-to in which to store passivated bean groups
	 */
	@SuppressWarnings("unchecked")
	public T groupsPath(String value) {
		this.groupsPath = value;
		return (T) this;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean will passivate
	 */
	@Binding(detypedName = "idle-timeout")
	public Long idleTimeout() {
		return this.idleTimeout;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean will passivate
	 */
	@SuppressWarnings("unchecked")
	public T idleTimeout(Long value) {
		this.idleTimeout = value;
		return (T) this;
	}

	/**
	 * The unit of idle-timeout
	 */
	@Binding(detypedName = "idle-timeout-unit")
	public String idleTimeoutUnit() {
		return this.idleTimeoutUnit;
	}

	/**
	 * The unit of idle-timeout
	 */
	@SuppressWarnings("unchecked")
	public T idleTimeoutUnit(String value) {
		this.idleTimeoutUnit = value;
		return (T) this;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@Binding(detypedName = "max-size")
	public Integer maxSize() {
		return this.maxSize;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@SuppressWarnings("unchecked")
	public T maxSize(Integer value) {
		this.maxSize = value;
		return (T) this;
	}

	/**
	 * The root path used to store passivated beans
	 */
	@Binding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The root path used to store passivated beans
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(String value) {
		this.relativeTo = value;
		return (T) this;
	}

	/**
	 * The subdirectory within the path specified by relative-to in which to store passivated beans
	 */
	@Binding(detypedName = "sessions-path")
	public String sessionsPath() {
		return this.sessionsPath;
	}

	/**
	 * The subdirectory within the path specified by relative-to in which to store passivated beans
	 */
	@SuppressWarnings("unchecked")
	public T sessionsPath(String value) {
		this.sessionsPath = value;
		return (T) this;
	}

	/**
	 * Specifies the number of subdirectories into which stored state should be divided, used to minimize the number of files created per directory
	 */
	@Binding(detypedName = "subdirectory-count")
	public Long subdirectoryCount() {
		return this.subdirectoryCount;
	}

	/**
	 * Specifies the number of subdirectories into which stored state should be divided, used to minimize the number of files created per directory
	 */
	@SuppressWarnings("unchecked")
	public T subdirectoryCount(Long value) {
		this.subdirectoryCount = value;
		return (T) this;
	}
}