package org.wildfly.swarm.config.io;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import java.util.List;
import org.wildfly.apigen.invocation.Subresource;
import org.wildfly.swarm.config.io.subsystem.worker.Worker;
import org.wildfly.swarm.config.io.subsystem.bufferPool.BufferPool;
/**
 * IO subsystem
 */
@Address("/subsystem=io")
@Implicit
public class Io<T extends Io> {

	private String key;
	private IoResources subresources = new IoResources();

	public Io() {
		this.key = "io";
	}

	public String getKey() {
		return this.key;
	}

	public IoResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Worker objects to this subresource
	 * @return this
	 * @param value List of Worker objects.
	 */
	@SuppressWarnings("unchecked")
	public T workers(List<Worker> value) {
		this.subresources.workers.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Worker object to the list of subresources
	 * @param value The Worker to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T worker(Worker value) {
		this.subresources.workers.add(value);
		return (T) this;
	}

	/**
	 * Add all BufferPool objects to this subresource
	 * @return this
	 * @param value List of BufferPool objects.
	 */
	@SuppressWarnings("unchecked")
	public T bufferPools(List<BufferPool> value) {
		this.subresources.bufferPools.addAll(value);
		return (T) this;
	}

	/**
	 * Add the BufferPool object to the list of subresources
	 * @param value The BufferPool to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bufferPool(BufferPool value) {
		this.subresources.bufferPools.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Io
	 */
	public class IoResources {
		/**
		 * Defines workers
		 */
		private List<Worker> workers = new java.util.ArrayList<>();
		/**
		 * Defines buffer pool
		 */
		private List<BufferPool> bufferPools = new java.util.ArrayList<>();

		/**
		 * Get the list of Worker resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Worker> workers() {
			return this.workers;
		}

		/**
		 * Get the list of BufferPool resources
		 * @return the list of resources
		 */
		@Subresource
		public List<BufferPool> bufferPools() {
			return this.bufferPools;
		}
	}
}