package org.wildfly.swarm.config.jca.subsystem.archiveValidation;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * Archive validation for resource adapters
 */
@Address("/subsystem=jca/archive-validation=archive-validation")
@Implicit
public class ArchiveValidation<T extends ArchiveValidation> {

	private String key;
	private Boolean enabled;
	private Boolean failOnError;
	private Boolean failOnWarn;

	public ArchiveValidation() {
		this.key = "archive-validation";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Specify whether archive validation is enabled
	 */
	@Binding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * Specify whether archive validation is enabled
	 */
	@SuppressWarnings("unchecked")
	public T enabled(Boolean value) {
		this.enabled = value;
		return (T) this;
	}

	/**
	 * Should an archive validation error report fail the deployment
	 */
	@Binding(detypedName = "fail-on-error")
	public Boolean failOnError() {
		return this.failOnError;
	}

	/**
	 * Should an archive validation error report fail the deployment
	 */
	@SuppressWarnings("unchecked")
	public T failOnError(Boolean value) {
		this.failOnError = value;
		return (T) this;
	}

	/**
	 * Should an archive validation warning report fail the deployment
	 */
	@Binding(detypedName = "fail-on-warn")
	public Boolean failOnWarn() {
		return this.failOnWarn;
	}

	/**
	 * Should an archive validation warning report fail the deployment
	 */
	@SuppressWarnings("unchecked")
	public T failOnWarn(Boolean value) {
		this.failOnWarn = value;
		return (T) this;
	}
}