package org.wildfly.swarm.config.jca.subsystem.beanValidation;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * Bean validation (JSR-303) for resource adapters
 */
@Address("/subsystem=jca/bean-validation=bean-validation")
@Implicit
public class BeanValidation<T extends BeanValidation> {

	private String key;
	private Boolean enabled;

	public BeanValidation() {
		this.key = "bean-validation";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Specify whether bean validation is enabled
	 */
	@Binding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * Specify whether bean validation is enabled
	 */
	@SuppressWarnings("unchecked")
	public T enabled(Boolean value) {
		this.enabled = value;
		return (T) this;
	}
}