package org.wildfly.swarm.config.jca.subsystem.bootstrapContext;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * Bootstrap context for resource adapters
 */
@Address("/subsystem=jca/bootstrap-context=*")
public class BootstrapContext<T extends BootstrapContext> {

	private String key;
	private String name;
	private String workmanager;

	public BootstrapContext(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the BootstrapContext
	 */
	@Binding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the BootstrapContext
	 */
	@SuppressWarnings("unchecked")
	public T name(String value) {
		this.name = value;
		return (T) this;
	}

	/**
	 * The WorkManager instance for the BootstrapContext
	 */
	@Binding(detypedName = "workmanager")
	public String workmanager() {
		return this.workmanager;
	}

	/**
	 * The WorkManager instance for the BootstrapContext
	 */
	@SuppressWarnings("unchecked")
	public T workmanager(String value) {
		this.workmanager = value;
		return (T) this;
	}
}