package org.wildfly.swarm.config.jca.subsystem.distributedWorkmanager.shortRunningThreads;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import java.util.Map;
/**
 * A thread pool executor with a bounded queue where threads submittings tasks will not block. Such a thread pool has a core and maximum size and a specified queue length.  When a task is submitted, if the number of running threads is less than the core size, a new thread is created.  Otherwise, if there is room in the queue, the task is enqueued. Otherwise, if the number of running threads is less than the maximum size, a new thread is created. Otherwise, the task is handed off to the designated handoff executor, if one is specified.  Otherwise, the task is discarded.
 */
@Address("/subsystem=jca/distributed-workmanager=*/short-running-threads=*")
public class ShortRunningThreads<T extends ShortRunningThreads> {

	private String key;
	private Boolean allowCoreTimeout;
	private Integer coreThreads;
	private Integer currentThreadCount;
	private String handoffExecutor;
	private Map keepaliveTime;
	private Integer largestThreadCount;
	private Integer maxThreads;
	private String name;
	private Integer queueLength;
	private Integer queueSize;
	private Integer rejectedCount;
	private String threadFactory;

	public ShortRunningThreads(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Whether core threads may time out.
	 */
	@Binding(detypedName = "allow-core-timeout")
	public Boolean allowCoreTimeout() {
		return this.allowCoreTimeout;
	}

	/**
	 * Whether core threads may time out.
	 */
	@SuppressWarnings("unchecked")
	public T allowCoreTimeout(Boolean value) {
		this.allowCoreTimeout = value;
		return (T) this;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If undefined, the core thread pool size is the same as the maximum thread pool size.
	 */
	@Binding(detypedName = "core-threads")
	public Integer coreThreads() {
		return this.coreThreads;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If undefined, the core thread pool size is the same as the maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public T coreThreads(Integer value) {
		this.coreThreads = value;
		return (T) this;
	}

	/**
	 * The current number of threads in the pool.
	 */
	@Binding(detypedName = "current-thread-count")
	public Integer currentThreadCount() {
		return this.currentThreadCount;
	}

	/**
	 * The current number of threads in the pool.
	 */
	@SuppressWarnings("unchecked")
	public T currentThreadCount(Integer value) {
		this.currentThreadCount = value;
		return (T) this;
	}

	/**
	 * An executor to delegate tasks to in the event that a task cannot be accepted. If not specified, tasks that cannot be accepted will be silently discarded.
	 */
	@Binding(detypedName = "handoff-executor")
	public String handoffExecutor() {
		return this.handoffExecutor;
	}

	/**
	 * An executor to delegate tasks to in the event that a task cannot be accepted. If not specified, tasks that cannot be accepted will be silently discarded.
	 */
	@SuppressWarnings("unchecked")
	public T handoffExecutor(String value) {
		this.handoffExecutor = value;
		return (T) this;
	}

	/**
	 * Used to specify the amount of time that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@Binding(detypedName = "keepalive-time")
	public Map keepaliveTime() {
		return this.keepaliveTime;
	}

	/**
	 * Used to specify the amount of time that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@SuppressWarnings("unchecked")
	public T keepaliveTime(Map value) {
		this.keepaliveTime = value;
		return (T) this;
	}

	/**
	 * The largest number of threads that have ever simultaneously been in the pool.
	 */
	@Binding(detypedName = "largest-thread-count")
	public Integer largestThreadCount() {
		return this.largestThreadCount;
	}

	/**
	 * The largest number of threads that have ever simultaneously been in the pool.
	 */
	@SuppressWarnings("unchecked")
	public T largestThreadCount(Integer value) {
		this.largestThreadCount = value;
		return (T) this;
	}

	/**
	 * The maximum thread pool size.
	 */
	@Binding(detypedName = "max-threads")
	public Integer maxThreads() {
		return this.maxThreads;
	}

	/**
	 * The maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public T maxThreads(Integer value) {
		this.maxThreads = value;
		return (T) this;
	}

	/**
	 * The name of the thread pool.
	 */
	@Binding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the thread pool.
	 */
	@SuppressWarnings("unchecked")
	public T name(String value) {
		this.name = value;
		return (T) this;
	}

	/**
	 * The queue length.
	 */
	@Binding(detypedName = "queue-length")
	public Integer queueLength() {
		return this.queueLength;
	}

	/**
	 * The queue length.
	 */
	@SuppressWarnings("unchecked")
	public T queueLength(Integer value) {
		this.queueLength = value;
		return (T) this;
	}

	/**
	 * The queue size.
	 */
	@Binding(detypedName = "queue-size")
	public Integer queueSize() {
		return this.queueSize;
	}

	/**
	 * The queue size.
	 */
	@SuppressWarnings("unchecked")
	public T queueSize(Integer value) {
		this.queueSize = value;
		return (T) this;
	}

	/**
	 * The number of tasks that have been passed to the handoff-executor (if one is specified) or discarded.
	 */
	@Binding(detypedName = "rejected-count")
	public Integer rejectedCount() {
		return this.rejectedCount;
	}

	/**
	 * The number of tasks that have been passed to the handoff-executor (if one is specified) or discarded.
	 */
	@SuppressWarnings("unchecked")
	public T rejectedCount(Integer value) {
		this.rejectedCount = value;
		return (T) this;
	}

	/**
	 * Specifies the name of a specific thread factory to use to create worker threads. If not defined an appropriate default thread factory will be used.
	 */
	@Binding(detypedName = "thread-factory")
	public String threadFactory() {
		return this.threadFactory;
	}

	/**
	 * Specifies the name of a specific thread factory to use to create worker threads. If not defined an appropriate default thread factory will be used.
	 */
	@SuppressWarnings("unchecked")
	public T threadFactory(String value) {
		this.threadFactory = value;
		return (T) this;
	}
}