package org.wildfly.swarm.config.jca.subsystem.tracer;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * Tracer for resource adapters
 */
@Address("/subsystem=jca/tracer=tracer")
@Implicit
public class Tracer<T extends Tracer> {

	private String key;
	private Boolean enabled;

	public Tracer() {
		this.key = "tracer";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Specify whether tracer is enabled
	 */
	@Binding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * Specify whether tracer is enabled
	 */
	@SuppressWarnings("unchecked")
	public T enabled(Boolean value) {
		this.enabled = value;
		return (T) this;
	}
}