package org.wildfly.swarm.config.jca.subsystem.workmanager;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import java.util.List;
import org.wildfly.apigen.invocation.Subresource;
import org.wildfly.swarm.config.jca.subsystem.workmanager.longRunningThreads.LongRunningThreads;
import org.wildfly.swarm.config.jca.subsystem.workmanager.shortRunningThreads.ShortRunningThreads;
/**
 * WorkManager for resource adapters
 */
@Address("/subsystem=jca/workmanager=*")
public class Workmanager<T extends Workmanager> {

	private String key;
	private String name;
	private WorkmanagerResources subresources = new WorkmanagerResources();

	public Workmanager(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the WorkManager
	 */
	@Binding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the WorkManager
	 */
	@SuppressWarnings("unchecked")
	public T name(String value) {
		this.name = value;
		return (T) this;
	}

	public WorkmanagerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all LongRunningThreads objects to this subresource
	 * @return this
	 * @param value List of LongRunningThreads objects.
	 */
	@SuppressWarnings("unchecked")
	public T longRunningThreads(List<LongRunningThreads> value) {
		this.subresources.longRunningThreads.addAll(value);
		return (T) this;
	}

	/**
	 * Add the LongRunningThreads object to the list of subresources
	 * @param value The LongRunningThreads to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T longRunningThreads(LongRunningThreads value) {
		this.subresources.longRunningThreads.add(value);
		return (T) this;
	}

	/**
	 * Add all ShortRunningThreads objects to this subresource
	 * @return this
	 * @param value List of ShortRunningThreads objects.
	 */
	@SuppressWarnings("unchecked")
	public T shortRunningThreads(List<ShortRunningThreads> value) {
		this.subresources.shortRunningThreads.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ShortRunningThreads object to the list of subresources
	 * @param value The ShortRunningThreads to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T shortRunningThreads(ShortRunningThreads value) {
		this.subresources.shortRunningThreads.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Workmanager
	 */
	public class WorkmanagerResources {
		/**
		 * A thread pool executor with a bounded queue where threads submittings tasks will not block. Such a thread pool has a core and maximum size and a specified queue length.  When a task is submitted, if the number of running threads is less than the core size, a new thread is created.  Otherwise, if there is room in the queue, the task is enqueued. Otherwise, if the number of running threads is less than the maximum size, a new thread is created. Otherwise, the task is handed off to the designated handoff executor, if one is specified.  Otherwise, the task is discarded.
		 */
		private List<LongRunningThreads> longRunningThreads = new java.util.ArrayList<>();
		/**
		 * A thread pool executor with a bounded queue where threads submittings tasks will not block. Such a thread pool has a core and maximum size and a specified queue length.  When a task is submitted, if the number of running threads is less than the core size, a new thread is created.  Otherwise, if there is room in the queue, the task is enqueued. Otherwise, if the number of running threads is less than the maximum size, a new thread is created. Otherwise, the task is handed off to the designated handoff executor, if one is specified.  Otherwise, the task is discarded.
		 */
		private List<ShortRunningThreads> shortRunningThreads = new java.util.ArrayList<>();

		/**
		 * Get the list of LongRunningThreads resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LongRunningThreads> longRunningThreads() {
			return this.longRunningThreads;
		}

		/**
		 * Get the list of ShortRunningThreads resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ShortRunningThreads> shortRunningThreads() {
			return this.shortRunningThreads;
		}
	}
}