package org.wildfly.swarm.config.jsf;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
/**
 * The JSF subsystem
 */
@Address("/subsystem=jsf")
@Implicit
public class Jsf<T extends Jsf> {

	private String key;
	private String defaultJsfImplSlot;

	public Jsf() {
		this.key = "jsf";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Default JSF implementation slot
	 */
	@Binding(detypedName = "default-jsf-impl-slot")
	public String defaultJsfImplSlot() {
		return this.defaultJsfImplSlot;
	}

	/**
	 * Default JSF implementation slot
	 */
	@SuppressWarnings("unchecked")
	public T defaultJsfImplSlot(String value) {
		this.defaultJsfImplSlot = value;
		return (T) this;
	}
}