package org.wildfly.swarm.config.logging.subsystem.logger;

import org.wildfly.apigen.invocation.Implicit;
import org.wildfly.apigen.invocation.Address;
import org.wildfly.apigen.invocation.Binding;
import java.util.Map;
import java.util.List;
/**
 * Defines a logger category.
 */
@Address("/subsystem=logging/logger=*")
public class Logger<T extends Logger> {

	private String key;
	private String category;
	private Map filter;
	private String filterSpec;
	private List<String> handlers;
	private String level;
	private Boolean useParentHandlers;

	public Logger(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Specifies the category for the logger.
	 */
	@Binding(detypedName = "category")
	public String category() {
		return this.category;
	}

	/**
	 * Specifies the category for the logger.
	 */
	@SuppressWarnings("unchecked")
	public T category(String value) {
		this.category = value;
		return (T) this;
	}

	/**
	 * Defines a simple filter type.
	 */
	@Binding(detypedName = "filter")
	public Map filter() {
		return this.filter;
	}

	/**
	 * Defines a simple filter type.
	 */
	@SuppressWarnings("unchecked")
	public T filter(Map value) {
		this.filter = value;
		return (T) this;
	}

	/**
	 * A filter expression value to define a filter. Example for a filter that does not match a pattern: not(match("JBAS.*"))
	 */
	@Binding(detypedName = "filter-spec")
	public String filterSpec() {
		return this.filterSpec;
	}

	/**
	 * A filter expression value to define a filter. Example for a filter that does not match a pattern: not(match("JBAS.*"))
	 */
	@SuppressWarnings("unchecked")
	public T filterSpec(String value) {
		this.filterSpec = value;
		return (T) this;
	}

	/**
	 * The handlers associated with the logger.
	 */
	@Binding(detypedName = "handlers")
	public List<String> handlers() {
		return this.handlers;
	}

	/**
	 * The handlers associated with the logger.
	 */
	@SuppressWarnings("unchecked")
	public T handlers(List<String> value) {
		this.handlers = value;
		return (T) this;
	}

	/**
	 * The log level specifying which message levels will be logged by the logger. Message levels lower than this value will be discarded.
	 */
	@Binding(detypedName = "level")
	public String level() {
		return this.level;
	}

	/**
	 * The log level specifying which message levels will be logged by the logger. Message levels lower than this value will be discarded.
	 */
	@SuppressWarnings("unchecked")
	public T level(String value) {
		this.level = value;
		return (T) this;
	}

	/**
	 * Specifies whether or not this logger should send its output to it's parent Logger.
	 */
	@Binding(detypedName = "use-parent-handlers")
	public Boolean useParentHandlers() {
		return this.useParentHandlers;
	}

	/**
	 * Specifies whether or not this logger should send its output to it's parent Logger.
	 */
	@SuppressWarnings("unchecked")
	public T useParentHandlers(Boolean value) {
		this.useParentHandlers = value;
		return (T) this;
	}
}