/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.tool.plugin;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.tools.plugin.ExtendedMojoDescriptor;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class PluginAdocGenerator
implements Generator {
    private final Locale locale;

    public PluginAdocGenerator() {
        this.locale = Locale.ENGLISH;
    }

    public PluginAdocGenerator(Locale locale) {
        this.locale = locale;
    }

    public void execute(File destinationDirectory, PluginToolsRequest request) throws GeneratorException {
        try {
            if (request.getPluginDescriptor().getMojos() != null) {
                List mojos = request.getPluginDescriptor().getMojos();
                for (MojoDescriptor descriptor : mojos) {
                    this.processMojoDescriptor(descriptor, destinationDirectory);
                }
            }
        }
        catch (IOException e) {
            throw new GeneratorException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMojoDescriptor(MojoDescriptor mojoDescriptor, File destinationDirectory) throws IOException {
        File outputFile = new File(destinationDirectory, this.getMojoFilename(mojoDescriptor, "adoc"));
        String encoding = "UTF-8";
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(outputFile, encoding);
            this.writeBody(mojoDescriptor, writer);
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
    }

    private String getMojoFilename(MojoDescriptor mojo, String ext) {
        return mojo.getGoal() + "-mojo." + ext;
    }

    private void writeBody(MojoDescriptor mojoDescriptor, PrintWriter w) {
        this.writeTitle(w, mojoDescriptor.getGoal());
        this.writeSection(w, mojoDescriptor.getFullGoalName(), this.getString("pluginasciidoc.mojodescriptor.fullname"), mojoDescriptor.getPluginDescriptor().getGroupId() + ":" + mojoDescriptor.getPluginDescriptor().getArtifactId() + ":" + mojoDescriptor.getPluginDescriptor().getVersion() + ":" + mojoDescriptor.getGoal());
        if (StringUtils.isNotEmpty((String)mojoDescriptor.getDeprecated())) {
            w.println();
            w.println("." + this.getString("pluginasciidoc.mojodescriptor.deprecated"));
            w.println("#### " + this.getString("pluginasciidoc.mojodescriptor.deprecated"));
            w.println();
            w.print(this.makeHtmlValid(mojoDescriptor.getDeprecated()));
            w.println();
        }
        w.println();
        w.println("." + this.getString("pluginasciidoc.description"));
        w.println("#### " + this.getString("pluginasciidoc.description"));
        w.println();
        if (StringUtils.isNotEmpty((String)mojoDescriptor.getDescription())) {
            w.println(this.makeHtmlValid(mojoDescriptor.getDescription()));
        } else {
            w.println(this.getString("pluginasciidoc.nodescription"));
        }
        w.println();
        this.writeGoalAttributes(mojoDescriptor, w);
        this.writeGoalParameterTable(mojoDescriptor, w);
    }

    private void writeTitle(PrintWriter w, String title) {
        w.print("### ");
        w.println(title);
        w.println();
    }

    private void writeSection(PrintWriter w, String title, String ... content) {
        w.print(".");
        w.println(title);
        w.print("#### ");
        w.println(title);
        for (String line : content) {
            w.println(line);
        }
        w.println();
    }

    private void writeGoalAttributes(MojoDescriptor mojoDescriptor, PrintWriter w) {
        String value;
        w.println("." + this.getString("pluginasciidoc.mojodescriptor.attributes"));
        w.println();
        if (mojoDescriptor.isProjectRequired()) {
            w.print("* ");
            w.println(this.getString("pluginasciidoc.mojodescriptor.projectRequired"));
        }
        if (mojoDescriptor.isRequiresReports()) {
            w.print("* ");
            w.println(this.getString("pluginasciidoc.mojodescriptor.reportingMojo"));
        }
        if (mojoDescriptor.isAggregator()) {
            w.print("* ");
            w.println(this.getString("pluginasciidoc.mojodescriptor.aggregator"));
        }
        if (mojoDescriptor.isDirectInvocationOnly()) {
            w.print("* ");
            w.println(this.getString("pluginasciidoc.mojodescriptor.directInvocationOnly"));
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.isDependencyResolutionRequired()))) {
            w.print("* ");
            w.println(this.format("pluginasciidoc.mojodescriptor.dependencyResolutionRequired", value));
        }
        if (mojoDescriptor instanceof ExtendedMojoDescriptor) {
            ExtendedMojoDescriptor extendedMojoDescriptor = (ExtendedMojoDescriptor)mojoDescriptor;
            value = extendedMojoDescriptor.getDependencyCollectionRequired();
            if (StringUtils.isNotEmpty((String)value)) {
                w.print("* ");
                w.println(this.format("pluginasciidoc.mojodescriptor.dependencyCollectionRequired", value));
            }
            if (extendedMojoDescriptor.isThreadSafe()) {
                w.print("* ");
                w.println(this.getString("pluginasciidoc.mojodescriptor.threadSafe"));
            }
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getSince()))) {
            w.print("* ");
            w.println(this.format("pluginasciidoc.mojodescriptor.since", value));
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getPhase()))) {
            w.print("* ");
            w.println(this.format("pluginasciidoc.mojodescriptor.phase", value));
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecutePhase()))) {
            w.print("* ");
            w.println(this.format("pluginasciidoc.mojodescriptor.executePhase", value));
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecuteGoal()))) {
            w.print("* ");
            w.println(this.format("pluginasciidoc.mojodescriptor.executeGoal", value));
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecuteLifecycle()))) {
            w.print("* ");
            w.println(this.format("pluginasciidoc.mojodescriptor.executeLifecycle", value));
        }
        if (mojoDescriptor.isOnlineRequired()) {
            w.print("* ");
            w.println(this.getString("pluginasciidoc.mojodescriptor.onlineRequired"));
        }
        if (!mojoDescriptor.isInheritedByDefault()) {
            w.print("* ");
            w.println(this.getString("pluginasciidoc.mojodescriptor.inheritedByDefault"));
        }
        w.println();
    }

    private void writeGoalParameterTable(MojoDescriptor mojoDescriptor, PrintWriter w) {
        List parameterList = mojoDescriptor.getParameters();
        List<Parameter> list = this.filterParameters(parameterList);
        if (list != null && list.size() > 0) {
            this.writeParameterSummary(mojoDescriptor, list, w);
            this.writeParameterDetails(mojoDescriptor, list, w);
        } else {
            this.writeSubsection(this.getString("pluginasciidoc.mojodescriptor.parameters"), w);
            w.println(this.getString("pluginasciidoc.mojodescriptor.noParameter"));
            w.println();
        }
    }

    private void writeSubsection(String name, PrintWriter w) {
        w.print(".");
        w.println(name);
        w.print("##### ");
        w.println(name);
        w.println();
    }

    private List<Parameter> filterParameters(List<Parameter> parameterList) {
        ArrayList<Parameter> filtered = new ArrayList<Parameter>();
        if (parameterList != null) {
            for (Parameter parameter : parameterList) {
                String expression;
                if (!parameter.isEditable() || (expression = parameter.getExpression()) != null && expression.startsWith("${component.")) continue;
                filtered.add(parameter);
            }
        }
        return filtered;
    }

    private void writeParameterDetails(MojoDescriptor mojoDescriptor, List<Parameter> parameterList, PrintWriter w) {
        this.writeSubsection(this.getString("pluginasciidoc.mojodescriptor.parameter.details"), w);
        Iterator<Parameter> parameters = parameterList.iterator();
        while (parameters.hasNext()) {
            Parameter parameter = parameters.next();
            w.println(this.format("pluginasciidoc.mojodescriptor.parameter.name_internal", parameter.getName()));
            if (StringUtils.isNotEmpty((String)parameter.getDeprecated())) {
                w.println(this.format("pluginasciidoc.mojodescriptor.parameter.deprecated", this.makeHtmlValid(parameter.getDeprecated())));
            }
            if (StringUtils.isNotEmpty((String)parameter.getDescription())) {
                w.println(this.makeHtmlValid(parameter.getDescription()));
            } else {
                w.println(this.getString("pluginasciidoc.nodescription"));
            }
            w.println();
            this.writeDetail(this.getString("pluginasciidoc.mojodescriptor.parameter.type"), parameter.getType(), w);
            if (StringUtils.isNotEmpty((String)parameter.getSince())) {
                this.writeDetail(this.getString("pluginasciidoc.mojodescriptor.parameter.since"), parameter.getSince(), w);
            } else if (StringUtils.isNotEmpty((String)mojoDescriptor.getSince())) {
                this.writeDetail(this.getString("pluginasciidoc.mojodescriptor.parameter.since"), mojoDescriptor.getSince(), w);
            }
            if (parameter.isRequired()) {
                this.writeDetail(this.getString("pluginasciidoc.mojodescriptor.parameter.required"), this.getString("pluginasciidoc.yes"), w);
            } else {
                this.writeDetail(this.getString("pluginasciidoc.mojodescriptor.parameter.required"), this.getString("pluginasciidoc.no"), w);
            }
            String expression = parameter.getExpression();
            String property = this.getPropertyFromExpression(expression);
            if (property == null) {
                this.writeDetail(this.getString("pluginasciidoc.mojodescriptor.parameter.expression"), expression, w);
            } else {
                this.writeDetail(this.getString("pluginasciidoc.mojodescriptor.parameter.property"), property, w);
            }
            this.writeDetail(this.getString("pluginasciidoc.mojodescriptor.parameter.default"), this.escapeXml(parameter.getDefaultValue()), w);
            this.writeDetail(this.getString("pluginasciidoc.mojodescriptor.parameter.alias"), this.escapeXml(parameter.getAlias()), w);
            w.println();
            if (parameters.hasNext()) {
                w.println();
            }
            w.println();
        }
        w.println();
    }

    private String getPropertyFromExpression(String expression) {
        if (StringUtils.isNotEmpty((String)expression) && expression.startsWith("${") && expression.endsWith("}") && !expression.substring(2).contains("${")) {
            return expression.substring(2, expression.length() - 1);
        }
        return null;
    }

    private void writeDetail(String param, String value, PrintWriter w) {
        if (StringUtils.isNotEmpty((String)value)) {
            w.print("* ");
            w.println(this.format("pluginasciidoc.detail", new String[]{param, value}));
        }
    }

    private void writeParameterSummary(MojoDescriptor mojoDescriptor, List<Parameter> parameterList, PrintWriter w) {
        List<Parameter> optionalParams;
        List<Parameter> requiredParams = this.getParametersByRequired(true, parameterList);
        if (requiredParams.size() > 0) {
            this.writeParameterList(mojoDescriptor, this.getString("pluginasciidoc.mojodescriptor.requiredParameters"), requiredParams, w);
        }
        if ((optionalParams = this.getParametersByRequired(false, parameterList)).size() > 0) {
            this.writeParameterList(mojoDescriptor, this.getString("pluginasciidoc.mojodescriptor.optionalParameters"), optionalParams, w);
        }
    }

    private void writeParameterList(MojoDescriptor mojoDescriptor, String title, List<Parameter> parameterList, PrintWriter w) {
        w.print(".");
        w.println(title);
        w.println("[%autowidth.stretch]");
        w.println("|====");
        w.print("|");
        w.print(this.getString("pluginasciidoc.mojodescriptor.parameter.name"));
        w.print("|");
        w.print(this.getString("pluginasciidoc.mojodescriptor.parameter.type"));
        w.print("|");
        w.print(this.getString("pluginasciidoc.mojodescriptor.parameter.since"));
        w.print("|");
        w.println(this.getString("pluginasciidoc.mojodescriptor.parameter.description"));
        for (Parameter parameter : parameterList) {
            String property;
            w.print("|");
            w.print(this.format("pluginasciidoc.mojodescriptor.parameter.name_link", parameter.getName()));
            w.print("|");
            int index = parameter.getType().lastIndexOf(".");
            w.print("`" + parameter.getType().substring(index + 1) + "`");
            w.print("|");
            if (StringUtils.isNotEmpty((String)parameter.getSince())) {
                w.print("`" + parameter.getSince() + "`");
            } else if (StringUtils.isNotEmpty((String)mojoDescriptor.getSince())) {
                w.print("`" + mojoDescriptor.getSince() + "`");
            } else {
                w.print("`-`");
            }
            w.print("|");
            String description = StringUtils.isNotEmpty((String)parameter.getDeprecated()) ? this.format("pluginasciidoc.mojodescriptor.parameter.deprecated", this.makeHtmlValid(parameter.getDeprecated())) : (StringUtils.isNotEmpty((String)parameter.getDescription()) ? this.makeHtmlValid(parameter.getDescription()) : this.getString("pluginasciidoc.nodescription"));
            w.println(description + " +");
            if (StringUtils.isNotEmpty((String)parameter.getDefaultValue())) {
                w.print(this.format("pluginasciidoc.mojodescriptor.parameter.defaultValue", this.escapeXml(parameter.getDefaultValue())));
                w.println(" +");
            }
            if ((property = this.getPropertyFromExpression(parameter.getExpression())) != null) {
                w.print(this.format("pluginasciidoc.mojodescriptor.parameter.property.description", property));
                w.println(" +");
            }
            if (StringUtils.isNotEmpty((String)parameter.getAlias())) {
                w.print(this.format("pluginasciidoc.mojodescriptor.parameter.alias.description", this.escapeXml(parameter.getAlias())));
            }
            w.println();
        }
        w.println();
        w.println("|====");
        w.println();
    }

    private String makeHtmlValid(String description) {
        String result = GeneratorUtils.makeHtmlValid((String)description);
        result = result.replaceAll("<code>", "`");
        result = result.replaceAll("</code>", "`");
        return result;
    }

    private List<Parameter> getParametersByRequired(boolean required, List<Parameter> parameterList) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (Parameter parameter : parameterList) {
            if (parameter.isRequired() != required) continue;
            list.add(parameter);
        }
        return list;
    }

    private ResourceBundle getBundle() {
        return ResourceBundle.getBundle("pluginasciidoc", this.locale, this.getClass().getClassLoader());
    }

    private String getString(String key) {
        return this.getBundle().getString(key);
    }

    private String format(String key, Object arg1) {
        return this.format(key, new Object[]{arg1});
    }

    private String format(String key, Object[] args) {
        String pattern = this.getString(key);
        pattern = StringUtils.replace((String)pattern, (String)"'", (String)"''");
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(this.locale);
        messageFormat.applyPattern(pattern);
        return messageFormat.format(args);
    }

    private String escapeXml(String text) {
        if (text != null) {
            text = text.replaceAll("&", "&amp;");
            text = text.replaceAll("<", "&lt;");
            text = text.replaceAll(">", "&gt;");
            text = text.replaceAll("\"", "&quot;");
            text = text.replaceAll("'", "&apos;");
        }
        return text;
    }
}

