/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.graphql.client.deployment;

import io.smallrye.graphql.client.model.ClientModelBuilder;
import io.smallrye.graphql.client.model.ClientModels;
import jakarta.enterprise.inject.spi.Extension;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.weld.WeldCapability;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.wildfly.extension.microprofile.graphql.client.ClientModelsExtension;
import org.wildfly.extension.microprofile.graphql.client._private.MicroProfileGraphQLClientLogger;

public class MicroProfileGraphQLClientDeploymentProcessor
implements DeploymentUnitProcessor {
    static final DotName GRAPHQL_CLIENT_API = DotName.createSimple((String)"io.smallrye.graphql.client.typesafe.api.GraphQLClientApi");
    private static ClientModels clientModels;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        WeldCapability weldCapability;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex.getAnnotations(GRAPHQL_CLIENT_API).isEmpty()) {
            return;
        }
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        MicroProfileGraphQLClientLogger.LOGGER.activatingGraphQLForDeployment(deploymentUnit.getName());
        Collection indexViews = compositeIndex.getIndexes().stream().map(index -> index).collect(Collectors.toList());
        try {
            weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw new RuntimeException("todo");
        }
        if (weldCapability.isPartOfWeldDeployment(deploymentUnit)) {
            ClientModels clientModels = ClientModelBuilder.build((IndexView)org.jboss.jandex.CompositeIndex.create((Collection)indexViews));
            weldCapability.registerExtensionInstance((Extension)new ClientModelsExtension(clientModels), deploymentUnit);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

