/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.graphql.deployment;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.microprofile.graphql._private.MicroProfileGraphQLLogger;

public class GraphiQLUIDeploymentProcessor
implements DeploymentUnitProcessor {
    private Closeable mountedOverlay;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        List rootList = deploymentUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.RESOURCE_ROOTS);
        try {
            for (ResourceRoot resourceRoot : rootList) {
                VirtualFile renderJsFile = resourceRoot.getRoot().getChild("META-INF/resources/graphql-ui/render.js");
                if (renderJsFile == null || !renderJsFile.isFile()) continue;
                String ctxRoot = GraphiQLUIDeploymentProcessor.determineContextRoot(deploymentUnit, ((WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY)).getMergedJBossWebMetaData());
                Path originalPath = renderJsFile.getPhysicalFile().toPath();
                Path pathToUpdatedRenderJs = Files.createTempFile(null, "render.js", new FileAttribute[0]);
                String graphQlPath = ctxRoot.endsWith("/") ? ctxRoot + "graphql" : ctxRoot + "/graphql";
                this.updateApiUrl(originalPath, pathToUpdatedRenderJs, graphQlPath);
                this.mountedOverlay = VFS.mountReal((File)pathToUpdatedRenderJs.toFile(), (VirtualFile)renderJsFile);
            }
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    static String determineContextRoot(DeploymentUnit deploymentUnit, JBossWebMetaData metaData) {
        if (metaData.getContextRoot() == null) {
            EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            if (description != null) {
                String moduleName = description.getModuleName();
                return "/" + (moduleName.equals("ROOT") ? "" : moduleName);
            }
            if (deploymentUnit.getName().equals("ROOT.war")) {
                return "/";
            }
            return "/" + deploymentUnit.getName().substring(0, deploymentUnit.getName().length() - 4);
        }
        String pathName = metaData.getContextRoot();
        if (pathName.length() > 0 && pathName.charAt(0) != '/') {
            return "/" + pathName;
        }
        return pathName;
    }

    private void updateApiUrl(Path renderJs, Path targetFile, String graphqlPath) throws IOException {
        String content = new String(Files.readAllBytes(renderJs), StandardCharsets.UTF_8);
        String result = this.updateApiUrl(content, graphqlPath);
        if (result.equals(content)) {
            MicroProfileGraphQLLogger.LOGGER.couldNotUpdateRenderJs(renderJs.toString());
        }
        Files.write(targetFile, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public String updateApiUrl(String original, String graphqlPath) {
        return original.replace("const api = '/graphql';", "const api = '" + graphqlPath + "';");
    }

    public void undeploy(DeploymentUnit context) {
        if (this.mountedOverlay != null) {
            try {
                this.mountedOverlay.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

