/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.graphql;

import graphql.ExecutionResult;
import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.graphql.execution.ExecutionService;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.control.RequestContextController;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@ServerEndpoint(value="/graphql")
public class SubscriptionWebSocket {
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);
    private final ConcurrentHashMap<String, AtomicReference<Subscription>> subscriptionRefs = new ConcurrentHashMap();
    @Inject
    ExecutionService executionService;
    @Inject
    RequestContextController requestContextController;

    @OnClose
    public void onClose(Session session) {
        this.unsubscribe(session.getId());
    }

    @OnError
    public void onError(Session session, Throwable throwable) throws IOException {
        throwable.printStackTrace();
        this.unsubscribe(session.getId());
        if (session.isOpen()) {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnMessage
    public void handleMessage(final Session session, String message) {
        this.requestContextController.activate();
        try (JsonReader jsonReader = jsonReaderFactory.createReader((Reader)new StringReader(message));){
            JsonObject jsonInput = jsonReader.readObject();
            ExecutionResponse executionResponse = this.executionService.execute(jsonInput);
            Publisher stream = (Publisher)executionResponse.getExecutionResult().getData();
            if (stream != null) {
                stream.subscribe((Subscriber)new Subscriber<ExecutionResult>(){

                    public void onSubscribe(Subscription s) {
                        AtomicReference<Subscription> subRef = (AtomicReference<Subscription>)SubscriptionWebSocket.this.subscriptionRefs.get(session.getId());
                        if (subRef == null) {
                            subRef = new AtomicReference<Subscription>(s);
                            SubscriptionWebSocket.this.subscriptionRefs.put(session.getId(), subRef);
                            s.request(1L);
                            return;
                        }
                        if (subRef.compareAndSet(null, s)) {
                            s.request(1L);
                        } else {
                            s.cancel();
                        }
                    }

                    public void onNext(ExecutionResult er) {
                        try {
                            if (session.isOpen()) {
                                ExecutionResponse executionResponse = new ExecutionResponse(er);
                                session.getBasicRemote().sendText(executionResponse.getExecutionResultAsString());
                                Subscription s = (Subscription)((AtomicReference)SubscriptionWebSocket.this.subscriptionRefs.get(session.getId())).get();
                                s.request(1L);
                            } else {
                                SubscriptionWebSocket.this.unsubscribe(session.getId());
                            }
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    }

                    public void onError(Throwable t) {
                        t.printStackTrace();
                        SubscriptionWebSocket.this.unsubscribe(session.getId());
                        try {
                            session.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }

                    public void onComplete() {
                        SubscriptionWebSocket.this.unsubscribe(session.getId());
                        try {
                            session.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        }
        finally {
            this.requestContextController.deactivate();
        }
    }

    private void unsubscribe(String sessionId) {
        AtomicReference<Subscription> subscription = this.subscriptionRefs.get(sessionId);
        this.subscriptionRefs.remove(sessionId);
        if (subscription != null && subscription.get() != null) {
            subscription.get().cancel();
            subscription.set(null);
        }
    }
}

