/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.graphql.deployment;

import io.smallrye.graphql.entry.http.ExecutionServlet;
import io.smallrye.graphql.entry.http.SchemaServlet;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.jandex.DotName;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.wildfly.extension.microprofile.graphql.WildFlyGraphQLServerWebSocket;
import org.wildfly.extension.microprofile.graphql._private.MicroProfileGraphQLLogger;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;

public class MicroProfileGraphQLDeploymentProcessor
implements DeploymentUnitProcessor {
    static final DotName ANNOTATION_GRAPHQL_API = DotName.createSimple((String)"org.eclipse.microprofile.graphql.GraphQLApi");
    static final DotName ANNOTATION_SUBSCRIPTION = DotName.createSimple((String)"io.smallrye.graphql.api.Subscription");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex.getAnnotations(ANNOTATION_GRAPHQL_API).isEmpty()) {
            return;
        }
        MicroProfileGraphQLLogger.LOGGER.activatingGraphQLForDeployment(deploymentUnit.getName());
        JBossWebMetaData mergedJBossWebMetaData = ((WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY)).getMergedJBossWebMetaData();
        this.registerStartupListener(mergedJBossWebMetaData);
        this.registerExecutionServlet(mergedJBossWebMetaData);
        this.registerSchemaServlet(mergedJBossWebMetaData);
        if (!compositeIndex.getAnnotations(ANNOTATION_SUBSCRIPTION).isEmpty()) {
            WebSocketDeploymentInfo webSocketDeploymentInfo = (WebSocketDeploymentInfo)deploymentUnit.getAttachment(UndertowAttachments.WEB_SOCKET_DEPLOYMENT_INFO);
            webSocketDeploymentInfo.addEndpoint(WildFlyGraphQLServerWebSocket.class);
            mergedJBossWebMetaData.setEnableWebSockets(true);
        }
    }

    private void registerStartupListener(JBossWebMetaData webdata) {
        ListenerMetaData startupListenerMetadata = new ListenerMetaData();
        startupListenerMetadata.setListenerClass("io.smallrye.graphql.entry.http.StartupListener");
        List containerListeners = webdata.getListeners();
        if (containerListeners == null) {
            ArrayList<ListenerMetaData> list = new ArrayList<ListenerMetaData>();
            list.add(startupListenerMetadata);
            webdata.setListeners(list);
        } else {
            containerListeners.add(startupListenerMetadata);
        }
    }

    private void registerExecutionServlet(JBossWebMetaData webdata) {
        JBossServletMetaData servlet = new JBossServletMetaData();
        servlet.setLoadOnStartup("1");
        servlet.setName("SmallRyeGraphQLExecutionServlet");
        servlet.setServletClass(ExecutionServlet.class.getName());
        servlet.setAsyncSupported(false);
        if (webdata.getServlets() == null) {
            webdata.setServlets(new JBossServletsMetaData());
        }
        webdata.getServlets().add((MappableMetaData)servlet);
        ServletMappingMetaData mapping = new ServletMappingMetaData();
        mapping.setServletName("SmallRyeGraphQLExecutionServlet");
        mapping.setUrlPatterns(Collections.singletonList("/graphql"));
        ArrayList<ServletMappingMetaData> mappings = webdata.getServletMappings();
        if (mappings != null) {
            mappings.add(mapping);
        } else {
            mappings = new ArrayList<ServletMappingMetaData>();
            mappings.add(mapping);
            webdata.setServletMappings(mappings);
        }
    }

    private void registerSchemaServlet(JBossWebMetaData webdata) {
        JBossServletMetaData servlet = new JBossServletMetaData();
        servlet.setLoadOnStartup("2");
        servlet.setName("SmallRyeGraphQLSchemaServlet");
        servlet.setServletClass(SchemaServlet.class.getName());
        servlet.setAsyncSupported(false);
        webdata.getServlets().add((MappableMetaData)servlet);
        ServletMappingMetaData mapping = new ServletMappingMetaData();
        mapping.setServletName("SmallRyeGraphQLSchemaServlet");
        mapping.setUrlPatterns(Collections.singletonList("/graphql/schema.graphql"));
        webdata.getServletMappings().add(mapping);
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

