package org.wildfly.extension.microprofile.graphql._private;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-09-02T14:37:11+0200")
public class MicroProfileGraphQLLogger_$logger extends DelegatingBasicLogger implements MicroProfileGraphQLLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MicroProfileGraphQLLogger_$logger.class.getName();
    public MicroProfileGraphQLLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void activatingSubsystem() {
        super.log.logf(FQCN, INFO, null, activatingSubsystem$str());
    }
    protected String activatingSubsystem$str() {
        return "WFLYGRAPHQL0001: Activating Eclipse MicroProfile GraphQL Subsystem";
    }
    @Override
    public final void activatingGraphQLForDeployment(final String deployment) {
        super.log.logf(FQCN, INFO, null, activatingGraphQLForDeployment$str(), deployment);
    }
    protected String activatingGraphQLForDeployment$str() {
        return "WFLYGRAPHQL0002: Activating GraphQL for deployment %s";
    }
    @Override
    public final void foundOperations(final int queries, final int mutations) {
        super.log.logf(FQCN, INFO, null, foundOperations$str(), queries, mutations);
    }
    protected String foundOperations$str() {
        return "WFLYGRAPHQL0003: Found %s queries and %s mutations in the API";
    }
    @Override
    public final void couldNotUpdateRenderJs(final String path) {
        super.log.logf(FQCN, WARN, null, couldNotUpdateRenderJs$str(), path);
    }
    protected String couldNotUpdateRenderJs$str() {
        return "WFLYGRAPHQL0004: Could not update %s because the contents are not as expected";
    }
    protected String multipleGraphQLApiAnnotations$str() {
        return "WFLYGRAPHQL0100: Multiple GraphQLApi annotations were found";
    }
    @Override
    public final DeploymentUnitProcessingException multipleGraphQLApiAnnotations() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), multipleGraphQLApiAnnotations$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
}
