/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import org.wildfly.extras.patch.Package;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchTool;
import org.wildfly.extras.patch.Repository;
import org.wildfly.extras.patch.ServerInstance;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.internal.DefaultPatchRepository;
import org.wildfly.extras.patch.internal.Lock;
import org.wildfly.extras.patch.internal.WildFlyServerInstance;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.PatchAssertion;

public final class DefaultPatchTool
implements PatchTool {
    private ServerInstance serverInstance;
    private Repository patchRepository;
    private Path serverPath;
    private URL repoUrl;

    public DefaultPatchTool(Path serverPath, URL repoUrl) {
        this.serverPath = serverPath;
        this.repoUrl = repoUrl;
    }

    @Override
    public ServerInstance getServerInstance() {
        if (this.serverInstance == null) {
            this.serverInstance = new WildFlyServerInstance(this.serverPath);
        }
        return this.serverInstance;
    }

    @Override
    public Repository getPatchRepository() {
        if (this.patchRepository == null) {
            if (this.repoUrl == null) {
                this.repoUrl = DefaultPatchRepository.getConfiguredUrl();
                if (this.repoUrl == null) {
                    try {
                        this.repoUrl = this.getServerInstance().getDefaultRepositoryPath().toUri().toURL();
                    }
                    catch (MalformedURLException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
            }
            this.patchRepository = new DefaultPatchRepository(this.repoUrl);
        }
        return this.patchRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package install(PatchId patchId, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        Lock.tryLock();
        try {
            Package package_ = this.installInternal(patchId, force);
            return package_;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package update(String prefix, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        Lock.tryLock();
        try {
            PatchId latestId = this.getPatchRepository().getLatestAvailable(prefix);
            PatchAssertion.assertNotNull(latestId, "Cannot obtain patch id for prefix: " + prefix);
            Package package_ = this.installInternal(latestId, force);
            return package_;
        }
        finally {
            Lock.unlock();
        }
    }

    private Package installInternal(PatchId patchId, boolean force) throws IOException {
        PatchId serverId = null;
        String prefix = patchId.getName();
        for (PatchId pid : this.getServerInstance().queryAppliedPatches()) {
            if (!pid.getName().equals(prefix)) continue;
            serverId = pid;
            break;
        }
        Package seedPatch = serverId != null ? this.getServerInstance().getPackage(serverId) : null;
        SmartPatch smartPatch = this.getPatchRepository().getSmartPatch(seedPatch, patchId);
        return this.getServerInstance().applySmartPatch(smartPatch, force);
    }
}

