/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.PatchException;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchTool;
import org.wildfly.extras.patch.PatchToolBuilder;
import org.wildfly.extras.patch.internal.Options;
import org.wildfly.extras.patch.internal.PatchLogger;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        try {
            Main.mainInternal(args);
        }
        catch (Throwable th) {
            Runtime.getRuntime().exit(1);
        }
    }

    public static void mainInternal(String[] args) throws Exception {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser(options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            Main.helpScreen(parser);
            return;
        }
        try {
            Main.run(parser, options);
        }
        catch (PatchException ex) {
            PatchLogger.error(ex);
            throw ex;
        }
        catch (Throwable th) {
            LOG.error("Error executing command", th);
            throw th;
        }
    }

    private static void run(CmdLineParser cmdParser, Options options) throws IOException {
        PatchTool patchTool;
        boolean opfound = false;
        if (options.queryServer) {
            patchTool = new PatchToolBuilder().serverPath(options.serverHome).build();
            Main.printPatches(patchTool.getServerInstance().queryAppliedPatches());
            opfound = true;
        }
        if (options.queryRepository) {
            patchTool = new PatchToolBuilder().repositoryUrl(options.repositoryUrl).build();
            Main.printPatches(patchTool.getPatchRepository().queryAvailable(null));
            opfound = true;
        }
        if (options.addUrl != null) {
            patchTool = new PatchToolBuilder().repositoryUrl(options.repositoryUrl).build();
            PatchId oneoffId = null;
            LinkedHashSet<PatchId> dependencies = new LinkedHashSet<PatchId>();
            if (options.patchId != null) {
                oneoffId = PatchId.fromString(options.patchId);
                dependencies.add(oneoffId);
            }
            if (options.depends != null) {
                for (String depid : options.depends) {
                    dependencies.add(PatchId.fromString(depid));
                }
            }
            patchTool.getPatchRepository().addArchive(options.addUrl, oneoffId, dependencies, options.force);
            opfound = true;
        }
        if (options.addCmd != null) {
            String[] cmdarr;
            PatchId patchId;
            patchTool = new PatchToolBuilder().repositoryUrl(options.repositoryUrl).build();
            if (options.addUrl != null) {
                patchId = PatchId.fromFile(new File(options.addUrl.getPath()));
                cmdarr = options.addCmd;
            } else {
                patchId = PatchId.fromString(options.addCmd[0]);
                cmdarr = Arrays.copyOfRange(options.addCmd, 1, options.addCmd.length);
            }
            patchTool.getPatchRepository().addPostCommand(patchId, cmdarr);
            opfound = true;
        }
        if (options.installId != null) {
            patchTool = new PatchToolBuilder().serverPath(options.serverHome).repositoryUrl(options.repositoryUrl).build();
            patchTool.install(PatchId.fromString(options.installId), options.force);
            opfound = true;
        }
        if (options.updateName != null) {
            patchTool = new PatchToolBuilder().serverPath(options.serverHome).repositoryUrl(options.repositoryUrl).build();
            patchTool.update(options.updateName, options.force);
            opfound = true;
        }
        if (options.auditLog) {
            patchTool = new PatchToolBuilder().serverPath(options.serverHome).build();
            Main.printLines(patchTool.getServerInstance().getAuditLog());
            opfound = true;
        }
        if (!opfound) {
            Main.helpScreen(cmdParser);
        }
    }

    private static void helpScreen(CmdLineParser cmdParser) {
        System.err.println("fusepatch [options...]");
        cmdParser.printUsage(System.err);
    }

    private static void printLines(List<String> lines) {
        for (String line : lines) {
            System.out.println(line);
        }
    }

    private static void printPatches(List<PatchId> patches) {
        for (PatchId patchId : patches) {
            System.out.println(patchId.toString());
        }
    }
}

