/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wildfly.extras.patch.Package;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

public final class SmartPatch {
    private final File patchFile;
    private final Package patchSet;
    private final Map<Path, Record> delMap = new HashMap<Path, Record>();
    private final Map<Path, Record> updMap = new HashMap<Path, Record>();
    private final Map<Path, Record> addMap = new HashMap<Path, Record>();

    public SmartPatch(Package patchSet, File patchFile) {
        IllegalArgumentAssertion.assertNotNull(patchFile, "patchFile");
        IllegalArgumentAssertion.assertNotNull(patchSet, "patchSet");
        this.patchSet = patchSet;
        this.patchFile = patchFile;
        block5: for (Record rec : patchSet.getRecords()) {
            Record.Action action = rec.getAction();
            switch (rec.getAction()) {
                case ADD: {
                    this.addMap.put(rec.getPath(), rec);
                    continue block5;
                }
                case UPD: {
                    this.updMap.put(rec.getPath(), rec);
                    continue block5;
                }
                case DEL: {
                    this.delMap.put(rec.getPath(), rec);
                    continue block5;
                }
            }
            throw new IllegalStateException((Object)((Object)action) + " no supported");
        }
    }

    public PatchId getPatchId() {
        return this.patchSet.getPatchId();
    }

    public File getPatchFile() {
        return this.patchFile;
    }

    public List<Record> getRecords() {
        return this.patchSet.getRecords();
    }

    public Set<PatchId> getDependencies() {
        return this.patchSet.getDependencies();
    }

    public Set<Record> getRemoveSet() {
        return Collections.unmodifiableSet(new HashSet<Record>(this.delMap.values()));
    }

    public boolean isRemovePath(Path path) {
        return this.delMap.containsKey(path);
    }

    public Set<Record> getReplaceSet() {
        return Collections.unmodifiableSet(new HashSet<Record>(this.updMap.values()));
    }

    public boolean isReplacePath(Path path) {
        return this.updMap.containsKey(path);
    }

    public Set<Record> getAddSet() {
        return Collections.unmodifiableSet(new HashSet<Record>(this.addMap.values()));
    }

    public boolean isAddPath(Path path) {
        return this.addMap.containsKey(path);
    }

    public List<String> getPostCommands() {
        return this.patchSet.getPostCommands();
    }

    public String toString() {
        return "SmartPatch[id=" + this.patchSet.getPatchId() + ",file=" + this.patchFile + ",add=" + this.addMap.size() + ",upd=" + this.updMap.size() + ",del=" + this.delMap.size() + "]";
    }
}

