/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.wildfly.extras.patch.Package;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.Repository;
import org.wildfly.extras.patch.Server;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.Version;
import org.wildfly.extras.patch.utils.PatchAssertion;

public abstract class PatchTool {
    public static final Version VERSION;

    public abstract Server getServer();

    public abstract Repository getRepository();

    public abstract Package install(PatchId var1, boolean var2) throws IOException;

    public abstract Package update(String var1, boolean var2) throws IOException;

    public abstract Package uninstall(PatchId var1, boolean var2) throws IOException;

    static {
        Version versionProp = null;
        try (InputStream input = SmartPatch.class.getResourceAsStream("version.properties");){
            BufferedReader br = new BufferedReader(new InputStreamReader(input));
            String line = br.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    versionProp = Version.parseVersion(line);
                    break;
                }
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        PatchAssertion.assertNotNull(versionProp, "Cannot obtain fusepatch version");
        VERSION = versionProp;
    }
}

