/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

public final class Package {
    private final PatchId identity;
    private final Map<Path, Record> recordsMap = new LinkedHashMap<Path, Record>();
    private final List<String> commands = new ArrayList<String>();
    private final Set<PatchId> dependencies = new LinkedHashSet<PatchId>();
    private int hashCache;

    public static Package create(PatchId patchId, Collection<Record> records) {
        return new Package(patchId, records, Collections.emptySet(), Collections.emptyList());
    }

    public static Package create(PatchId patchId, Collection<Record> records, Set<PatchId> dependencies) {
        return new Package(patchId, records, dependencies, Collections.emptyList());
    }

    public static Package create(PatchId patchId, Collection<Record> records, List<String> commands) {
        return new Package(patchId, records, Collections.emptySet(), commands);
    }

    public static Package create(PatchId patchId, Collection<Record> records, Set<PatchId> dependencies, List<String> commands) {
        return new Package(patchId, records, dependencies, commands);
    }

    public static Package smartSet(Package seedPatch, Package targetSet) {
        IllegalArgumentAssertion.assertNotNull(targetSet, "targetSet");
        HashMap<Path, Record> removeMap = new HashMap<Path, Record>();
        if (seedPatch != null) {
            for (Record rec : seedPatch.getRecords()) {
                removeMap.put(rec.getPath(), Record.create(null, Record.Action.DEL, rec.getPath(), rec.getChecksum()));
            }
        }
        HashSet<Record> records = new HashSet<Record>();
        for (Record rec : targetSet.getRecords()) {
            Path path = rec.getPath();
            Long checksum = rec.getChecksum();
            if (removeMap.containsValue(rec)) {
                removeMap.remove(path);
                continue;
            }
            if (removeMap.containsKey(path)) {
                removeMap.remove(path);
                records.add(Record.create(null, Record.Action.UPD, path, checksum));
                continue;
            }
            records.add(Record.create(null, Record.Action.ADD, path, checksum));
        }
        records.addAll(removeMap.values());
        return new Package(targetSet.identity, records, targetSet.dependencies, targetSet.commands);
    }

    private Package(PatchId patchId, Collection<Record> records, Set<PatchId> dependencies, List<String> commands) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        IllegalArgumentAssertion.assertNotNull(records, "records");
        IllegalArgumentAssertion.assertNotNull(dependencies, "dependencies");
        IllegalArgumentAssertion.assertNotNull(commands, "commands");
        this.dependencies.addAll(dependencies);
        this.commands.addAll(commands);
        this.identity = patchId;
        HashMap<Path, Record> auxmap = new HashMap<Path, Record>();
        for (Record aux : records) {
            auxmap.put(aux.getPath(), Record.create(patchId, aux.getAction(), aux.getPath(), aux.getChecksum()));
        }
        ArrayList paths = new ArrayList(auxmap.keySet());
        Collections.sort(paths);
        for (Path path : paths) {
            this.recordsMap.put(path, (Record)auxmap.get(path));
        }
    }

    public PatchId getPatchId() {
        return this.identity;
    }

    public List<Record> getRecords() {
        return Collections.unmodifiableList(new ArrayList<Record>(this.recordsMap.values()));
    }

    public boolean containsPath(Path path) {
        return this.recordsMap.containsKey(path);
    }

    public Record getRecord(Path path) {
        return this.recordsMap.get(path);
    }

    public Set<PatchId> getDependencies() {
        return this.dependencies;
    }

    public List<String> getPostCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = ("" + this.identity + this.recordsMap + this.commands).hashCode();
        }
        return this.hashCache;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Package)) {
            return false;
        }
        Package other = (Package)obj;
        boolean result = this.identity.equals(other.identity);
        result &= this.recordsMap.equals(other.recordsMap);
        result &= this.dependencies.equals(other.dependencies);
        return result &= this.commands.equals(other.commands);
    }

    public String toString() {
        return "Package[" + this.identity + ",recs=" + this.recordsMap.size() + ",deps=" + this.dependencies + ",cmds=" + this.commands.size() + "]";
    }
}

