/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.repository;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.wildfly.extras.patch.Patch;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchMetadata;
import org.wildfly.extras.patch.PatchMetadataBuilder;
import org.wildfly.extras.patch.Repository;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.repository.PatchAdapter;
import org.wildfly.extras.patch.repository.PatchMetadataAdapter;
import org.wildfly.extras.patch.repository.RepositoryService;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

public class RepositoryClient
implements Repository {
    private final Lock lock;
    private final URL endpointUrl;
    private final RepositoryService delegate;

    public RepositoryClient(Lock lock, URL endpointUrl, String username, String password) {
        IllegalArgumentAssertion.assertNotNull(endpointUrl, "endpointUrl");
        IllegalArgumentAssertion.assertNotNull(lock, "lock");
        this.endpointUrl = endpointUrl;
        this.lock = lock;
        URL wsdlUrl = this.getClass().getClassLoader().getResource("/jaxws/repository-endpoint.wsdl");
        this.delegate = (RepositoryService)Service.create((URL)wsdlUrl, (QName)RepositoryService.SERVICE_QNAME).getPort(RepositoryService.class);
        if (username != null && password != null) {
            BindingProvider bp = (BindingProvider)this.delegate;
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpointUrl.toString());
            bp.getRequestContext().put("javax.xml.ws.security.auth.username", username);
            bp.getRequestContext().put("javax.xml.ws.security.auth.password", password);
        }
    }

    @Override
    public URL getRepositoryURL() {
        return this.endpointUrl;
    }

    @Override
    public List<PatchId> queryAvailable(String prefix) {
        this.lock.tryLock();
        try {
            ArrayList<PatchId> result = new ArrayList<PatchId>();
            String[] available = this.delegate.queryAvailable(prefix);
            if (available != null) {
                for (String spec : available) {
                    result.add(PatchId.fromString(spec));
                }
            }
            List<PatchId> list = Collections.unmodifiableList(result);
            return list;
        }
        catch (WebServiceException ex) {
            throw this.unwrap(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public PatchId getLatestAvailable(String prefix) {
        this.lock.tryLock();
        try {
            String result = this.delegate.getLatestAvailable(prefix);
            PatchId patchId = result != null ? PatchId.fromString(result) : null;
            return patchId;
        }
        catch (WebServiceException ex) {
            throw this.unwrap(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Patch getPatch(PatchId patchId) {
        this.lock.tryLock();
        try {
            PatchAdapter result = this.delegate.getPatch(patchId.toString());
            Patch patch = result != null ? result.toPatch() : null;
            return patch;
        }
        catch (WebServiceException ex) {
            throw this.unwrap(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public PatchId addArchive(URL fileUrl) throws IOException {
        this.lock.tryLock();
        try {
            PatchId patchId = PatchId.fromURL(fileUrl);
            DataHandler dataHandler = new DataHandler((DataSource)new URLDataSource(fileUrl));
            PatchMetadata metadata = new PatchMetadataBuilder().patchId(patchId).build();
            PatchId patchId2 = this.addArchive(metadata, dataHandler, false);
            return patchId2;
        }
        catch (WebServiceException ex) {
            throw this.unwrap(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public PatchId addArchive(URL fileUrl, boolean force) throws IOException {
        this.lock.tryLock();
        try {
            PatchId patchId = PatchId.fromURL(fileUrl);
            DataHandler dataHandler = new DataHandler((DataSource)new URLDataSource(fileUrl));
            PatchMetadata metadata = new PatchMetadataBuilder().patchId(patchId).build();
            PatchId patchId2 = this.addArchive(metadata, dataHandler, force);
            return patchId2;
        }
        catch (WebServiceException ex) {
            throw this.unwrap(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public PatchId addArchive(PatchMetadata metadata, DataHandler dataHandler, boolean force) throws IOException {
        this.lock.tryLock();
        try {
            String result = this.delegate.addArchive(PatchMetadataAdapter.fromPatchMetadata(metadata), dataHandler, force);
            PatchId patchId = PatchId.fromString(result);
            return patchId;
        }
        catch (WebServiceException ex) {
            throw this.unwrap(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean removeArchive(PatchId removeId) {
        this.lock.tryLock();
        try {
            boolean bl = this.delegate.removeArchive(removeId.toString());
            return bl;
        }
        catch (WebServiceException ex) {
            throw this.unwrap(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public SmartPatch getSmartPatch(Patch seedPatch, PatchId patchId) {
        this.lock.tryLock();
        try {
            SmartPatch smartPatch = this.delegate.getSmartPatch(PatchAdapter.fromPatch(seedPatch), patchId.toString()).toSmartPatch();
            return smartPatch;
        }
        catch (WebServiceException ex) {
            throw this.unwrap(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    private RuntimeException unwrap(WebServiceException ex) {
        String prefix;
        Throwable result = ex;
        String message = ex.getMessage();
        if (message.startsWith(prefix = SecurityException.class.getName() + ": ")) {
            message = message.substring(prefix.length());
            result = new SecurityException(message);
        }
        return result;
    }
}

