/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.wildfly.extras.patch.PatchToolBuilder;
import org.wildfly.extras.patch.aether.AetherFactory;

public final class Configuration {
    public static final String PROPERTY_SERVER_HOME = "server.home";
    public static final String PROPERTY_REPOSITORY_URL = "repository.url";
    public static final String PROPERTY_REPOSITORY_USERNAME = "repository.username";
    public static final String PROPERTY_REPOSITORY_PASSWORD = "repository.password";
    public static final String PROPERTY_AETHER_FACTORY = "aether.factory";
    private Path serverPath;
    private URL repoUrl;
    private String aetherFactory;
    private String username;
    private String password;

    private Configuration() {
    }

    public static Configuration load(URL configURL) throws IOException {
        Properties props = new Properties();
        try (InputStream input = configURL.openStream();){
            props.load(input);
        }
        return Configuration.load(props);
    }

    public static Configuration load(Properties props) {
        Configuration config = new Configuration();
        String propval = props.getProperty(PROPERTY_SERVER_HOME);
        if (propval != null) {
            config.serverPath = Paths.get(propval, new String[0]);
        }
        if ((propval = props.getProperty(PROPERTY_REPOSITORY_URL)) != null) {
            try {
                config.repoUrl = new URL(propval);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        if ((propval = props.getProperty(PROPERTY_REPOSITORY_USERNAME)) != null) {
            config.username = propval;
        }
        if ((propval = props.getProperty(PROPERTY_REPOSITORY_PASSWORD)) != null) {
            config.password = propval;
        }
        if ((propval = props.getProperty(PROPERTY_AETHER_FACTORY)) != null) {
            config.aetherFactory = propval;
        }
        return config;
    }

    public void loadPatchToolBuilder(PatchToolBuilder builder) {
        if (this.repoUrl != null) {
            builder.repositoryURL(this.repoUrl);
        }
        if (this.serverPath != null) {
            builder.serverPath(this.serverPath);
        }
        if (this.username != null && this.password != null) {
            builder.credentials(this.username, this.password);
        }
        if (this.aetherFactory != null) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(this.aetherFactory);
                builder.aetherFactory((AetherFactory)clazz.newInstance());
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

