/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.repository;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchMetadata;
import org.wildfly.extras.patch.PatchMetadataBuilder;

public class PatchMetadataAdapter {
    private String patchId;
    private String[] roles;
    private String[] dependencySpecs;
    private String[] commands;

    public static PatchMetadataAdapter fromPatchMetadata(PatchMetadata metadata) {
        if (metadata == null) {
            return null;
        }
        PatchMetadataAdapter result = new PatchMetadataAdapter();
        result.patchId = metadata.getPatchId().toString();
        ArrayList<String> roles = new ArrayList<String>(metadata.getRoles());
        result.roles = new String[roles.size()];
        for (int i = 0; i < roles.size(); ++i) {
            result.roles[i] = (String)roles.get(i);
        }
        ArrayList<PatchId> dependencies = new ArrayList<PatchId>(metadata.getDependencies());
        result.dependencySpecs = new String[dependencies.size()];
        for (int i = 0; i < dependencies.size(); ++i) {
            result.dependencySpecs[i] = ((PatchId)dependencies.get(i)).toString();
        }
        List<String> cmdlist = metadata.getPostCommands();
        result.commands = new String[cmdlist.size()];
        cmdlist.toArray(result.commands);
        return result;
    }

    public PatchMetadata toPatchMetadata() {
        PatchId pid = PatchId.fromString(this.patchId);
        HashSet<PatchId> dependencies = new HashSet<PatchId>();
        if (this.dependencySpecs != null) {
            for (String spec : this.dependencySpecs) {
                dependencies.add(PatchId.fromString(spec));
            }
        }
        return new PatchMetadataBuilder().patchId(pid).roles(this.roles).dependencies(dependencies).postCommands(this.commands).build();
    }

    public String getPatchId() {
        return this.patchId;
    }

    public void setPatchId(String identity) {
        this.patchId = identity;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
    }

    public String[] getDependencies() {
        return this.dependencySpecs;
    }

    public void setDependencies(String[] dependencies) {
        this.dependencySpecs = dependencies;
    }

    public String[] getCommands() {
        return this.commands;
    }

    public void setCommands(String[] commands) {
        this.commands = commands;
    }
}

