/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchRepository;
import org.wildfly.extras.patch.PatchSet;
import org.wildfly.extras.patch.PatchTool;
import org.wildfly.extras.patch.ServerInstance;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.internal.DefaultPatchRepository;
import org.wildfly.extras.patch.internal.WildFlyServerInstance;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

public final class DefaultPatchTool
implements PatchTool {
    private ServerInstance serverInstance;
    private PatchRepository patchRepository;
    private Path serverPath;
    private URL repoUrl;

    public DefaultPatchTool(Path serverPath, URL repoUrl) {
        this.serverPath = serverPath;
        this.repoUrl = repoUrl;
    }

    @Override
    public List<PatchId> queryServer() {
        return this.getServerInstance().queryAppliedPatches();
    }

    @Override
    public List<PatchId> queryRepository() {
        return this.getPatchRepository().queryAvailable(null);
    }

    @Override
    public PatchId add(URL fileUrl) throws IOException {
        return this.getPatchRepository().addArchive(fileUrl);
    }

    @Override
    public void addPostCommand(PatchId patchId, String cmd) {
        this.getPatchRepository().addPostCommand(patchId, cmd);
    }

    @Override
    public PatchSet install(PatchId patchId) throws IOException {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        PatchId latestId = null;
        String symbolicName = patchId.getSymbolicName();
        for (PatchId pid : this.getServerInstance().queryAppliedPatches()) {
            if (!pid.getSymbolicName().equals(symbolicName)) continue;
            latestId = pid;
        }
        PatchSet latest = latestId != null ? this.getServerInstance().getPatchSet(latestId) : null;
        SmartPatch smartPatch = this.getPatchRepository().getSmartPatch(latest, patchId);
        return this.getServerInstance().applySmartPatch(smartPatch);
    }

    @Override
    public PatchSet update(String prefix) throws IOException {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        PatchId latestId = null;
        for (PatchId patchId : this.getServerInstance().queryAppliedPatches()) {
            if (!patchId.getSymbolicName().equals(prefix)) continue;
            latestId = patchId;
        }
        PatchId patchId = null;
        Iterator<PatchId> iterator = this.getPatchRepository().queryAvailable(prefix).iterator();
        while (iterator.hasNext()) {
            PatchId pid3;
            patchId = pid3 = iterator.next();
        }
        PatchSet patchSet = latestId != null ? this.getServerInstance().getPatchSet(latestId) : null;
        SmartPatch smartPatch = this.getPatchRepository().getSmartPatch(patchSet, patchId);
        return this.getServerInstance().applySmartPatch(smartPatch);
    }

    private ServerInstance getServerInstance() {
        if (this.serverInstance == null) {
            this.serverInstance = new WildFlyServerInstance(this.serverPath);
        }
        return this.serverInstance;
    }

    private PatchRepository getPatchRepository() {
        if (this.patchRepository == null) {
            if (this.repoUrl == null) {
                this.repoUrl = DefaultPatchRepository.getConfiguredUrl();
                if (this.repoUrl == null) {
                    try {
                        this.repoUrl = this.getServerInstance().getDefaultRepositoryPath().toUri().toURL();
                    }
                    catch (MalformedURLException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
            }
            this.patchRepository = new DefaultPatchRepository(this.repoUrl);
        }
        return this.patchRepository;
    }
}

