/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.IOException;
import java.util.List;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchTool;
import org.wildfly.extras.patch.PatchToolBuilder;
import org.wildfly.extras.patch.internal.Options;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser(options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            Main.helpScreen(parser);
            return;
        }
        try {
            Main.run(parser, options);
        }
        catch (Exception rte) {
            LOG.error("Cannot run fusepatch", (Throwable)rte);
            rte.printStackTrace(System.err);
            Runtime.getRuntime().exit(1);
        }
    }

    private static void run(CmdLineParser cmdParser, Options options) throws IOException {
        PatchTool patchTool;
        boolean opfound = false;
        if (options.queryServer) {
            patchTool = new PatchToolBuilder().serverPath(options.serverHome).build();
            Main.printPatches(patchTool.queryServer());
            opfound = true;
        }
        if (options.queryRepository) {
            patchTool = new PatchToolBuilder().repositoryUrl(options.repositoryUrl).build();
            Main.printPatches(patchTool.queryRepository());
            opfound = true;
        }
        if (options.addUrl != null) {
            patchTool = new PatchToolBuilder().repositoryUrl(options.repositoryUrl).build();
            patchTool.add(options.addUrl);
            opfound = true;
        }
        if (options.addCmd != null) {
            patchTool = new PatchToolBuilder().repositoryUrl(options.repositoryUrl).build();
            int index = options.addCmd.indexOf(":");
            PatchId patchId = index > 0 ? PatchId.fromString(options.addCmd.substring(0, index)) : null;
            String cmd = index > 0 ? options.addCmd.substring(index + 1) : options.addCmd;
            patchTool.addPostCommand(patchId, cmd);
            opfound = true;
        }
        if (options.installId != null) {
            patchTool = new PatchToolBuilder().serverPath(options.serverHome).repositoryUrl(options.repositoryUrl).build();
            patchTool.install(PatchId.fromString(options.installId));
            opfound = true;
        }
        if (options.updateName != null) {
            patchTool = new PatchToolBuilder().serverPath(options.serverHome).repositoryUrl(options.repositoryUrl).build();
            patchTool.update(options.updateName);
            opfound = true;
        }
        if (!opfound) {
            Main.helpScreen(cmdParser);
        }
    }

    private static void helpScreen(CmdLineParser cmdParser) {
        System.err.println("fusepatch [options...]");
        cmdParser.printUsage(System.err);
    }

    private static void printPatches(List<PatchId> patches) {
        for (PatchId patchId : patches) {
            LOG.info(patchId.toString());
        }
    }
}

