/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.io.File;
import org.wildfly.extras.patch.Version;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

public final class PatchId
implements Comparable<PatchId> {
    private final String symbolicName;
    private final Version version;
    private final String canonicalForm;

    public static PatchId create(String symbolicName, String version) {
        return new PatchId(symbolicName, version != null ? Version.parseVersion(version) : null);
    }

    public static PatchId create(String symbolicName, Version version) {
        return new PatchId(symbolicName, version);
    }

    public static PatchId fromString(String identity) {
        int index = identity.indexOf(45);
        if (index < 0) {
            return new PatchId(identity, Version.emptyVersion);
        }
        while (index > 0) {
            String namePart = identity.substring(0, index);
            String versionPart = identity.substring(index + 1);
            try {
                Version version = Version.parseVersion(versionPart);
                return new PatchId(namePart, version);
            }
            catch (RuntimeException ex) {
                index = identity.indexOf(45, index + 1);
            }
        }
        return new PatchId(identity, Version.emptyVersion);
    }

    public static PatchId fromFile(File file) {
        String name = file.getName();
        return PatchId.fromString(name.substring(0, name.lastIndexOf(46)));
    }

    private PatchId(String symbolicName, Version version) {
        IllegalArgumentAssertion.assertNotNull(symbolicName, "symbolicName");
        this.symbolicName = symbolicName.trim();
        this.version = version != null ? version : Version.emptyVersion;
        this.canonicalForm = this.symbolicName + "-" + this.version;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getCanonicalForm() {
        return this.canonicalForm;
    }

    public int hashCode() {
        return this.canonicalForm.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PatchId)) {
            return false;
        }
        PatchId other = (PatchId)obj;
        return this.canonicalForm.equals(other.canonicalForm);
    }

    @Override
    public int compareTo(PatchId other) {
        int result = this.symbolicName.compareTo(other.symbolicName);
        if (result == 0) {
            result = this.version.compareTo(other.version);
        }
        return result;
    }

    public String toString() {
        return this.canonicalForm;
    }
}

