/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchSet;
import org.wildfly.extras.patch.ServerInstance;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.internal.Parser;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;

public final class WildFlyServerInstance
implements ServerInstance {
    private static final Logger LOG = LoggerFactory.getLogger(WildFlyServerInstance.class);
    private final Path homePath;

    public WildFlyServerInstance(Path homePath) {
        if (homePath == null) {
            homePath = WildFlyServerInstance.getConfiguredHomePath();
        }
        IllegalStateAssertion.assertNotNull(homePath, "Cannot obtain JBOSS_HOME");
        IllegalStateAssertion.assertTrue(homePath.toFile().isDirectory(), "Directory JBOSS_HOME does not exist: " + homePath);
        this.homePath = homePath.toAbsolutePath();
    }

    @Override
    public Path getDefaultRepositoryPath() {
        return this.homePath.resolve(Paths.get("fusepatch", "repository"));
    }

    @Override
    public Path getServerHome() {
        return this.homePath;
    }

    @Override
    public List<PatchId> queryAppliedPatches() {
        return Parser.getAvailable(this.getWorkspace(), null, true);
    }

    @Override
    public PatchId getLatestApplied(String prefix) {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        List<PatchId> list = Parser.getAvailable(this.getWorkspace(), prefix, true);
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public PatchSet getPatchSet(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        try {
            return Parser.readPatchSet(this.getWorkspace(), patchId);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public PatchSet applySmartPatch(SmartPatch smartPatch) throws IOException {
        Path path;
        IllegalArgumentAssertion.assertNotNull(smartPatch, "smartPatch");
        if (smartPatch.getRemoveSet().isEmpty() && smartPatch.getReplaceSet().isEmpty() && smartPatch.getAddSet().isEmpty()) {
            LOG.warn("Nothing to do with: {}", (Object)smartPatch.getPatchId());
            return null;
        }
        PatchId patchId = smartPatch.getPatchId();
        PatchId latestId = this.getLatestApplied(patchId.getSymbolicName());
        String message = latestId == null ? "Install: " + patchId : (latestId.compareTo(patchId) < 0 ? "Upgrade from " + latestId + " to " + patchId : (latestId.compareTo(patchId) == 0 ? "Reinstall: " + patchId : "Downgrade from " + latestId + " to " + patchId));
        LOG.info(message);
        HashMap<Path, PatchSet.Record> records = new HashMap<Path, PatchSet.Record>();
        if (latestId != null) {
            Iterator<PatchSet.Record> patchSet = this.getPatchSet(latestId);
            for (PatchSet.Record rec : ((PatchSet)((Object)patchSet)).getRecords()) {
                records.put(rec.getPath(), rec);
            }
        }
        for (PatchSet.Record record : smartPatch.getRemoveSet()) {
            path = this.getServerHome().resolve(record.getPath());
            if (!path.toFile().exists()) {
                LOG.warn("Attempt to delete non existing file: {}", (Object)path);
            }
            records.remove(record.getPath());
        }
        for (PatchSet.Record record : smartPatch.getReplaceSet()) {
            path = this.getServerHome().resolve(record.getPath());
            if (!path.toFile().exists()) {
                LOG.warn("Attempt to replace non existing file: {}", (Object)path);
            }
            records.put(record.getPath(), record);
        }
        for (PatchSet.Record record : smartPatch.getAddSet()) {
            path = this.getServerHome().resolve(record.getPath());
            if (path.toFile().exists()) {
                LOG.warn("Attempt to add already existing file: {}", (Object)path);
            }
            records.put(record.getPath(), record);
        }
        this.updateServerFiles(smartPatch);
        HashSet<PatchSet.Record> inforecs = new HashSet<PatchSet.Record>();
        for (PatchSet.Record rec : records.values()) {
            inforecs.add(PatchSet.Record.create(rec.getPath(), rec.getChecksum()));
        }
        PatchSet patchSet = PatchSet.create(patchId, inforecs);
        Parser.writePatchSet(this.getWorkspace(), patchSet);
        Parser.writeAuditLog(this.getWorkspace(), message, smartPatch);
        Runtime runtime = Runtime.getRuntime();
        File procdir = this.homePath.toFile();
        for (String cmd : smartPatch.getPostCommands()) {
            String[] envarr = new String[]{};
            String[] cmdarr = cmd.split("\\s");
            Process proc = runtime.exec(cmdarr, envarr, procdir);
            try {
                if (proc.waitFor() == 0) continue;
                LOG.error("Command did not terminate normally: " + cmd);
                break;
            }
            catch (InterruptedException ex) {
            }
        }
        return patchSet;
    }

    private void updateServerFiles(SmartPatch smartPatch) throws IOException {
        for (PatchSet.Record rec : smartPatch.getRemoveSet()) {
            Path path = this.getServerHome().resolve(rec.getPath());
            Files.delete(path);
        }
        File patchFile = smartPatch.getPatchFile();
        try (ZipInputStream zip = new ZipInputStream(new FileInputStream(patchFile));){
            byte[] buffer = new byte[1024];
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                Path path;
                if (!entry.isDirectory() && (smartPatch.isReplacePath(path = Paths.get(entry.getName(), new String[0])) || smartPatch.isAddPath(path))) {
                    File file = this.homePath.resolve(path).toFile();
                    file.getParentFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(file);){
                        int read = zip.read(buffer);
                        while (read > 0) {
                            fos.write(buffer, 0, read);
                            read = zip.read(buffer);
                        }
                    }
                    if (file.getName().endsWith(".sh") || file.getName().endsWith(".bat")) {
                        file.setExecutable(true);
                    }
                }
                entry = zip.getNextEntry();
            }
        }
    }

    private Path getWorkspace() {
        return this.homePath.resolve(Paths.get("fusepatch", "workspace"));
    }

    static Path getConfiguredHomePath() {
        String jbossHome = System.getProperty("jboss.home");
        if (jbossHome == null) {
            jbossHome = System.getProperty("jboss.home.dir");
        }
        if (jbossHome == null) {
            jbossHome = System.getenv("JBOSS_HOME");
        }
        return jbossHome != null ? Paths.get(jbossHome, new String[0]) : null;
    }
}

