/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.ManagedPath;
import org.wildfly.extras.patch.PatchException;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchTool;
import org.wildfly.extras.patch.PatchToolBuilder;
import org.wildfly.extras.patch.internal.Options;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        try {
            Main.mainInternal(args);
        }
        catch (Throwable th) {
            Runtime.getRuntime().exit(1);
        }
    }

    public static void mainInternal(String[] args) throws Exception {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            Main.helpScreen(parser);
            return;
        }
        try {
            Main.run(parser, options);
        }
        catch (PatchException ex) {
            LOG.error("ERROR {}", (Object)ex.getMessage());
            LOG.debug("Patch Exception", (Throwable)ex);
            throw ex;
        }
        catch (Throwable th) {
            LOG.error("Error executing command", th);
            throw th;
        }
    }

    private static void run(CmdLineParser cmdParser, Options options) throws IOException {
        PatchTool patchTool;
        boolean opfound = false;
        if (options.queryRepository) {
            patchTool = new PatchToolBuilder().repositoryUrl(options.repositoryUrl).build();
            Main.printPatches(patchTool.getRepository().queryAvailable(null));
            opfound = true;
        }
        if (options.queryServer) {
            patchTool = new PatchToolBuilder().serverPath(options.serverHome).build();
            Main.printPatches(patchTool.getServer().queryAppliedPackages());
            opfound = true;
        }
        if (options.queryServerPaths != null) {
            patchTool = new PatchToolBuilder().serverPath(options.serverHome).build();
            ArrayList<String> managedPaths = new ArrayList<String>();
            for (ManagedPath managedPath : patchTool.getServer().queryManagedPaths(options.queryServerPaths)) {
                managedPaths.add(managedPath.toString());
            }
            Main.printLines(managedPaths);
            opfound = true;
        }
        if (options.addUrl != null) {
            patchTool = new PatchToolBuilder().repositoryUrl(options.repositoryUrl).build();
            PatchId oneoffId = null;
            LinkedHashSet<PatchId> dependencies = new LinkedHashSet<PatchId>();
            if (options.oneoffId != null) {
                oneoffId = PatchId.fromString(options.oneoffId);
                dependencies.add(oneoffId);
            }
            if (options.dependencies != null) {
                for (String depid : options.dependencies) {
                    dependencies.add(PatchId.fromString(depid));
                }
            }
            patchTool.getRepository().addArchive(options.addUrl, oneoffId, dependencies, options.force);
            opfound = true;
        }
        if (options.removeId != null) {
            patchTool = new PatchToolBuilder().repositoryUrl(options.repositoryUrl).build();
            patchTool.getRepository().removeArchive(PatchId.fromString(options.removeId));
            opfound = true;
        }
        if (options.addCmd != null) {
            String[] cmdarr;
            PatchId patchId;
            patchTool = new PatchToolBuilder().repositoryUrl(options.repositoryUrl).build();
            if (options.addUrl != null) {
                patchId = PatchId.fromURL(options.addUrl);
                cmdarr = options.addCmd;
            } else {
                patchId = PatchId.fromString(options.addCmd[0]);
                cmdarr = Arrays.copyOfRange(options.addCmd, 1, options.addCmd.length);
            }
            patchTool.getRepository().addPostCommand(patchId, cmdarr);
            opfound = true;
        }
        if (options.installId != null) {
            patchTool = new PatchToolBuilder().serverPath(options.serverHome).repositoryUrl(options.repositoryUrl).build();
            patchTool.install(PatchId.fromString(options.installId), options.force);
            opfound = true;
        }
        if (options.updateName != null) {
            patchTool = new PatchToolBuilder().serverPath(options.serverHome).repositoryUrl(options.repositoryUrl).build();
            patchTool.update(options.updateName, options.force);
            opfound = true;
        }
        if (options.uninstallId != null) {
            patchTool = new PatchToolBuilder().serverPath(options.serverHome).build();
            patchTool.uninstall(PatchId.fromString(options.uninstallId), options.force);
            opfound = true;
        }
        if (options.auditLog) {
            patchTool = new PatchToolBuilder().serverPath(options.serverHome).build();
            Main.printLines(patchTool.getServer().getAuditLog());
            opfound = true;
        }
        if (!opfound) {
            Main.helpScreen(cmdParser);
        }
    }

    private static void helpScreen(CmdLineParser cmdParser) {
        System.err.println("fusepatch [options...]");
        cmdParser.printUsage((OutputStream)System.err);
    }

    private static void printLines(List<String> lines) {
        for (String line : lines) {
            System.out.println(line);
        }
    }

    private static void printPatches(List<PatchId> patches) {
        for (PatchId patchId : patches) {
            System.out.println(patchId.toString());
        }
    }
}

