/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.wildfly.extras.patch.Patch;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchMetadata;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

public final class SmartPatch
implements Closeable {
    private final Patch patch;
    private final DataHandler dataHandler;
    private final Map<Path, Record> delMap = new HashMap<Path, Record>();
    private final Map<Path, Record> updMap = new HashMap<Path, Record>();
    private final Map<Path, Record> addMap = new HashMap<Path, Record>();

    public static SmartPatch forInstall(Patch patch, DataHandler dataHandler) {
        IllegalArgumentAssertion.assertNotNull(dataHandler, "dataHandler");
        return new SmartPatch(patch, dataHandler);
    }

    public static SmartPatch forUninstall(Patch patch) {
        IllegalArgumentAssertion.assertNotNull(patch, "patch");
        PatchId patchId = patch.getPatchId();
        ArrayList<Record> records = new ArrayList<Record>();
        for (Record rec : patch.getRecords()) {
            records.add(Record.create(patchId, Record.Action.DEL, rec.getPath(), rec.getChecksum()));
        }
        return new SmartPatch(Patch.create(patch.getMetadata(), records), null);
    }

    private SmartPatch(Patch patch, DataHandler dataHandler) {
        IllegalArgumentAssertion.assertNotNull(patch, "patch");
        this.patch = patch;
        this.dataHandler = dataHandler;
        block5: for (Record rec : patch.getRecords()) {
            Record.Action action = rec.getAction();
            switch (rec.getAction()) {
                case ADD: {
                    this.addMap.put(rec.getPath(), rec);
                    continue block5;
                }
                case UPD: {
                    this.updMap.put(rec.getPath(), rec);
                    continue block5;
                }
                case DEL: {
                    this.delMap.put(rec.getPath(), rec);
                    continue block5;
                }
            }
            throw new IllegalStateException((Object)((Object)action) + " no supported");
        }
    }

    public PatchId getPatchId() {
        return this.patch.getPatchId();
    }

    public Patch getPatch() {
        return this.patch;
    }

    public DataHandler getDataHandler() {
        return this.dataHandler;
    }

    public boolean isUninstall() {
        return this.dataHandler == null;
    }

    public List<Record> getRecords() {
        return this.patch.getRecords();
    }

    public PatchMetadata getMetadata() {
        return this.patch.getMetadata();
    }

    public Set<Record> getRemoveSet() {
        return Collections.unmodifiableSet(new HashSet<Record>(this.delMap.values()));
    }

    public boolean isRemovePath(Path path) {
        return this.delMap.containsKey(path);
    }

    public Set<Record> getReplaceSet() {
        return Collections.unmodifiableSet(new HashSet<Record>(this.updMap.values()));
    }

    public boolean isReplacePath(Path path) {
        return this.updMap.containsKey(path);
    }

    public Set<Record> getAddSet() {
        return Collections.unmodifiableSet(new HashSet<Record>(this.addMap.values()));
    }

    public boolean isAddPath(Path path) {
        return this.addMap.containsKey(path);
    }

    @Override
    public void close() throws IOException {
        DataSource dataSource;
        DataSource dataSource2 = dataSource = this.dataHandler != null ? this.dataHandler.getDataSource() : null;
        if (dataSource instanceof Closeable) {
            ((Closeable)dataSource).close();
        }
    }

    public String toString() {
        return "SmartPatch[id=" + this.patch.getPatchId() + ",add=" + this.addMap.size() + ",upd=" + this.updMap.size() + ",del=" + this.delMap.size() + "]";
    }
}

