/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.repository;

import java.util.ArrayList;
import javax.activation.DataHandler;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.repository.PatchAdapter;

public class SmartPatchAdapter {
    private DataHandler dataHandler;
    private PatchAdapter patch;
    private String[] removeRecs;
    private String[] replaceRecs;
    private String[] addRecs;

    public static SmartPatchAdapter fromSmartPatch(SmartPatch smartPatch) {
        SmartPatchAdapter result = new SmartPatchAdapter();
        result.dataHandler = smartPatch.getDataHandler();
        result.patch = PatchAdapter.fromPatch(smartPatch.getPatch());
        ArrayList<Record> removeSet = new ArrayList<Record>(smartPatch.getRemoveSet());
        result.removeRecs = new String[removeSet.size()];
        for (int i = 0; i < removeSet.size(); ++i) {
            result.removeRecs[i] = ((Record)removeSet.get(i)).toString();
        }
        ArrayList<Record> replaceSet = new ArrayList<Record>(smartPatch.getReplaceSet());
        result.replaceRecs = new String[replaceSet.size()];
        for (int i = 0; i < replaceSet.size(); ++i) {
            result.replaceRecs[i] = ((Record)replaceSet.get(i)).toString();
        }
        ArrayList<Record> addSet = new ArrayList<Record>(smartPatch.getAddSet());
        result.addRecs = new String[addSet.size()];
        for (int i = 0; i < addSet.size(); ++i) {
            result.addRecs[i] = ((Record)addSet.get(i)).toString();
        }
        return result;
    }

    public SmartPatch toSmartPatch() {
        if (this.dataHandler != null) {
            return SmartPatch.forInstall(this.patch.toPatch(), this.dataHandler);
        }
        return SmartPatch.forUninstall(this.patch.toPatch());
    }

    public DataHandler getDataHandler() {
        return this.dataHandler;
    }

    public void setDataHandler(DataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    public PatchAdapter getPatch() {
        return this.patch;
    }

    public void setPatch(PatchAdapter patch) {
        this.patch = patch;
    }

    public String[] getRemoveRecs() {
        return this.removeRecs;
    }

    public void setRemoveRecs(String[] removeRecs) {
        this.removeRecs = removeRecs;
    }

    public String[] getReplaceRecs() {
        return this.replaceRecs;
    }

    public void setReplaceRecs(String[] updateRecs) {
        this.replaceRecs = updateRecs;
    }

    public String[] getAddRecs() {
        return this.addRecs;
    }

    public void setAddRecs(String[] addRecs) {
        this.addRecs = addRecs;
    }
}

