/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.server;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.ManagedPaths;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.server.AbstractServer;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;

public final class WildFlyServer
extends AbstractServer {
    private static final Logger LOG = LoggerFactory.getLogger(WildFlyServer.class);
    public static final String MODULE_LAYER = "fuse";

    public WildFlyServer(Lock lock, Path homePath) {
        super(lock, WildFlyServer.assertHomePath(homePath));
    }

    private static Path assertHomePath(Path homePath) {
        if (homePath == null) {
            homePath = WildFlyServer.getDefaultServerPath();
        }
        IllegalStateAssertion.assertNotNull(homePath, "Cannot obtain JBOSS_HOME");
        IllegalStateAssertion.assertTrue(homePath.toFile().isDirectory(), "Directory JBOSS_HOME does not exist: " + homePath);
        return homePath;
    }

    public static Path getDefaultServerPath() {
        Path currpath;
        String jbossHome = System.getProperty("jboss.home");
        if (jbossHome == null) {
            jbossHome = System.getProperty("jboss.home.dir");
        }
        if (jbossHome == null) {
            jbossHome = System.getenv("JBOSS_HOME");
        }
        if (jbossHome == null && (currpath = Paths.get(".", new String[0])).resolve("jboss-modules.jar").toFile().exists()) {
            jbossHome = currpath.toAbsolutePath().toString();
        }
        return jbossHome != null ? Paths.get(jbossHome, new String[0]) : null;
    }

    @Override
    protected void updateServerFiles(SmartPatch smartPatch, ManagedPaths managedPaths) throws IOException {
        super.updateServerFiles(smartPatch, managedPaths);
        Path homePath = this.getServerHome();
        Path modulesPath = homePath.resolve("modules");
        if (modulesPath.toFile().isDirectory()) {
            Properties props = new Properties();
            Path layersPath = modulesPath.resolve("layers.conf");
            if (layersPath.toFile().isFile()) {
                try (FileReader fr = new FileReader(layersPath.toFile());){
                    props.load(fr);
                }
            }
            ArrayList<String> layers = new ArrayList<String>();
            String value = props.getProperty("layers");
            if (value != null) {
                for (String layer : value.split(",")) {
                    layers.add(layer.trim());
                }
            }
            if (!layers.contains(MODULE_LAYER)) {
                layers.add(0, MODULE_LAYER);
                value = "";
                for (String layer : layers) {
                    value = value + "," + layer;
                }
                value = value.substring(1);
                props.setProperty("layers", value);
                LOG.warn("Layers config does not contain 'fuse', writing: {}", (Object)value);
                try (FileWriter fw = new FileWriter(layersPath.toFile());){
                    props.store(fw, "Fixed by fusepatch");
                }
            }
        }
    }

    public String toString() {
        return "WildFlyServer[home=" + this.getServerHome() + "]";
    }
}

